"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.POLICY_ARTIFACT_DELETE_MODAL_LABELS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const POLICY_ARTIFACT_DELETE_MODAL_LABELS = Object.freeze({
  deleteModalTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.list.removeDialog.title', {
    defaultMessage: 'Remove artifact from policy'
  }),
  deleteModalImpactInfo: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.list.removeDialog.messageCallout', {
    defaultMessage: 'This artifact will be removed only from this policy and can still be found and managed from the artifact page.'
  }),
  deleteModalConfirmInfo: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.list.removeDialog.message', {
    defaultMessage: 'Are you sure you wish to continue?'
  }),
  deleteModalSubmitButtonTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.list.removeDialog.confirmLabel', {
    defaultMessage: 'Remove from policy'
  }),
  deleteModalCancelButtonTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.list.removeDialog.cancelLabel', {
    defaultMessage: 'Cancel'
  }),
  deleteModalSuccessMessageTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.list.removeDialog.successToastTitle', {
    defaultMessage: 'Successfully removed'
  }),
  deleteModalSuccessMessageText: (exception, policyName) => _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.list.removeDialog.successToastText', {
    defaultMessage: '"{artifactName}" has been removed from {policyName} policy',
    values: {
      artifactName: exception.name,
      policyName
    }
  }),
  deleteModalErrorMessage: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.list.removeDialog.errorToastTitle', {
    defaultMessage: 'Error while attempting to remove artifact'
  })
});
exports.POLICY_ARTIFACT_DELETE_MODAL_LABELS = POLICY_ARTIFACT_DELETE_MODAL_LABELS;