"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.policySettingsMiddlewareRunner = void 0;
var _policy_config = require("../../../../../../../common/endpoint/models/policy_config");
var _policy_settings_selectors = require("../selectors/policy_settings_selectors");
var _ingest = require("../../../../../services/policies/ingest");
var _policy = require("../../../../../../../common/endpoint/service/policy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const policySettingsMiddlewareRunner = async ({
  coreStart
}, {
  dispatch,
  getState
}, action) => {
  const http = coreStart.http;
  const state = getState();
  if (action.type === 'userChangedUrl' && (0, _policy_settings_selectors.needsToRefresh)(state) && (0, _policy_settings_selectors.isOnPolicyDetailsPage)(state)) {
    const id = (0, _policy_settings_selectors.policyIdFromParams)(state);
    let policyItem;
    try {
      policyItem = (await (0, _ingest.sendGetPackagePolicy)(http, id)).item;
      // sets default user notification message if policy config message is empty
      if (policyItem.inputs[0].config.policy.value.windows.popup.malware.message === '') {
        policyItem.inputs[0].config.policy.value.windows.popup.malware.message = _policy_config.DefaultPolicyNotificationMessage;
        policyItem.inputs[0].config.policy.value.mac.popup.malware.message = _policy_config.DefaultPolicyNotificationMessage;
        policyItem.inputs[0].config.policy.value.linux.popup.malware.message = _policy_config.DefaultPolicyNotificationMessage;
      }
      if (policyItem.inputs[0].config.policy.value.windows.popup.ransomware.message === '') {
        policyItem.inputs[0].config.policy.value.windows.popup.ransomware.message = _policy_config.DefaultPolicyNotificationMessage;
      }
      if (policyItem.inputs[0].config.policy.value.windows.popup.memory_protection.message === '') {
        policyItem.inputs[0].config.policy.value.windows.popup.memory_protection.message = _policy_config.DefaultPolicyRuleNotificationMessage;
      }
      if (policyItem.inputs[0].config.policy.value.mac.popup.memory_protection.message === '') {
        policyItem.inputs[0].config.policy.value.mac.popup.memory_protection.message = _policy_config.DefaultPolicyRuleNotificationMessage;
      }
      if (policyItem.inputs[0].config.policy.value.linux.popup.memory_protection.message === '') {
        policyItem.inputs[0].config.policy.value.linux.popup.memory_protection.message = _policy_config.DefaultPolicyRuleNotificationMessage;
      }
      if (policyItem.inputs[0].config.policy.value.windows.popup.behavior_protection.message === '') {
        policyItem.inputs[0].config.policy.value.windows.popup.behavior_protection.message = _policy_config.DefaultPolicyRuleNotificationMessage;
      }
      if (policyItem.inputs[0].config.policy.value.mac.popup.behavior_protection.message === '') {
        policyItem.inputs[0].config.policy.value.mac.popup.behavior_protection.message = _policy_config.DefaultPolicyRuleNotificationMessage;
      }
      if (policyItem.inputs[0].config.policy.value.linux.popup.behavior_protection.message === '') {
        policyItem.inputs[0].config.policy.value.linux.popup.behavior_protection.message = _policy_config.DefaultPolicyRuleNotificationMessage;
      }
    } catch (error) {
      dispatch({
        type: 'serverFailedToReturnPolicyDetailsData',
        payload: error.body || error
      });
      return;
    }
    dispatch({
      type: 'serverReturnedPolicyDetailsData',
      payload: {
        policyItem
      }
    });

    // Agent summary is secondary data, so its ok for it to come after the details
    // page is populated with the main content
    if (policyItem.policy_id) {
      const {
        results
      } = await (0, _ingest.sendGetFleetAgentStatusForPolicy)(http, policyItem.policy_id);
      dispatch({
        type: 'serverReturnedPolicyDetailsAgentSummaryData',
        payload: {
          agentStatusSummary: results
        }
      });
    }
  } else if (action.type === 'userClickedPolicyDetailsSaveButton') {
    const {
      id
    } = (0, _policy_settings_selectors.policyDetails)(state);
    const updatedPolicyItem = (0, _policy_settings_selectors.policyDetailsForUpdate)(state);
    let apiResponse;
    try {
      apiResponse = await (0, _ingest.sendPutPackagePolicy)(http, id, updatedPolicyItem).catch(error => {
        if (!error.response || error.response.status !== 409) {
          return Promise.reject(error);
        }
        // Handle 409 error (version conflict) here, by using the latest document
        // for the package policy and adding the updated policy to it, ensuring that
        // any recent updates to `manifest_artifacts` are retained.
        return (0, _ingest.sendGetPackagePolicy)(http, id).then(packagePolicy => {
          const latestUpdatedPolicyItem = packagePolicy.item;
          latestUpdatedPolicyItem.inputs[0].config.policy = updatedPolicyItem.inputs[0].config.policy;
          return (0, _ingest.sendPutPackagePolicy)(http, id, (0, _policy.getPolicyDataForUpdate)(latestUpdatedPolicyItem));
        });
      });
    } catch (error) {
      dispatch({
        type: 'serverReturnedPolicyDetailsUpdateFailure',
        payload: {
          success: false,
          error: error.body || error
        }
      });
      return;
    }
    dispatch({
      type: 'serverReturnedUpdatedPolicyDetailsData',
      payload: {
        policyItem: apiResponse.item,
        updateStatus: {
          success: true
        }
      }
    });
  }
};
exports.policySettingsMiddlewareRunner = policySettingsMiddlewareRunner;