"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setIn = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns cloned `configuration` with `value` set by the `keyPath`.
 */
const setIn = a => key => subKey => leafKey => v => {
  const c = (0, _lodash.cloneDeep)(a);
  c[key][subKey][leafKey] = v;
  return c;
};
exports.setIn = setIn;