"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RULE_NAME = exports.OS_LABEL = exports.NAME_LABEL = exports.NAME_ERROR = exports.EventFiltersList = exports.DESCRIPTION_LABEL = exports.ABOUT_EVENT_FILTERS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _user_privileges = require("../../../../common/components/user_privileges");
var _kibana = require("../../../../common/lib/kibana");
var _artifact_list_page = require("../../../components/artifact_list_page");
var _api_client = require("../service/api_client");
var _form = require("./components/form");
var _constants = require("../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ABOUT_EVENT_FILTERS = _i18n.i18n.translate('xpack.securitySolution.eventFilters.aboutInfo', {
  defaultMessage: 'Event filters exclude high volume or unwanted events from being written to Elasticsearch.'
});
exports.ABOUT_EVENT_FILTERS = ABOUT_EVENT_FILTERS;
const NAME_LABEL = _i18n.i18n.translate('xpack.securitySolution.eventFilter.form.name.label', {
  defaultMessage: 'Name'
});
exports.NAME_LABEL = NAME_LABEL;
const DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.securitySolution.eventFilter.form.description.placeholder', {
  defaultMessage: 'Description'
});
exports.DESCRIPTION_LABEL = DESCRIPTION_LABEL;
const NAME_ERROR = _i18n.i18n.translate('xpack.securitySolution.eventFilter.form.name.error', {
  defaultMessage: "The name can't be empty"
});
exports.NAME_ERROR = NAME_ERROR;
const OS_LABEL = _i18n.i18n.translate('xpack.securitySolution.eventFilter.form.os.label', {
  defaultMessage: 'Select operating system'
});
exports.OS_LABEL = OS_LABEL;
const RULE_NAME = _i18n.i18n.translate('xpack.securitySolution.eventFilter.form.rule.name', {
  defaultMessage: 'Endpoint Event Filtering'
});
exports.RULE_NAME = RULE_NAME;
const EVENT_FILTERS_PAGE_LABELS = {
  pageTitle: _i18n.i18n.translate('xpack.securitySolution.eventFilters.pageTitle', {
    defaultMessage: 'Event Filters'
  }),
  pageAboutInfo: _i18n.i18n.translate('xpack.securitySolution.eventFilters.pageAboutInfo', {
    defaultMessage: 'Event filters exclude high volume or unwanted events from being written to Elasticsearch.'
  }),
  pageAddButtonTitle: _i18n.i18n.translate('xpack.securitySolution.eventFilters.pageAddButtonTitle', {
    defaultMessage: 'Add event filter'
  }),
  getShowingCountLabel: total => _i18n.i18n.translate('xpack.securitySolution.eventFilters.showingTotal', {
    defaultMessage: 'Showing {total} {total, plural, one {event filter} other {event filters}}',
    values: {
      total
    }
  }),
  cardActionEditLabel: _i18n.i18n.translate('xpack.securitySolution.eventFilters.cardActionEditLabel', {
    defaultMessage: 'Edit event filter'
  }),
  cardActionDeleteLabel: _i18n.i18n.translate('xpack.securitySolution.eventFilters.cardActionDeleteLabel', {
    defaultMessage: 'Delete event filter'
  }),
  flyoutCreateTitle: _i18n.i18n.translate('xpack.securitySolution.eventFilters.flyoutCreateTitle', {
    defaultMessage: 'Add event filter'
  }),
  flyoutEditTitle: _i18n.i18n.translate('xpack.securitySolution.eventFilters.flyoutEditTitle', {
    defaultMessage: 'Edit event filter'
  }),
  flyoutCreateSubmitButtonLabel: _i18n.i18n.translate('xpack.securitySolution.eventFilters.flyoutCreateSubmitButtonLabel', {
    defaultMessage: 'Add event filter'
  }),
  flyoutCreateSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.eventFilters.flyoutCreateSubmitSuccess', {
    defaultMessage: '"{name}" has been added to the event filters list.',
    values: {
      name
    }
  }),
  flyoutEditSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.eventFilters.flyoutEditSubmitSuccess', {
    defaultMessage: '"{name}" has been updated.',
    values: {
      name
    }
  }),
  flyoutDowngradedLicenseDocsInfo: securitySolutionDocsLinks => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.eventFilters.flyoutDowngradedLicenseDocsInfo",
      defaultMessage: "For more information, see our "
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      target: "_blank",
      href: `${securitySolutionDocsLinks.eventFilters}`
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.eventFilters.flyoutDowngradedLicenseDocsLink",
      defaultMessage: "Event filters documentation"
    })));
  },
  deleteActionSuccess: itemName => _i18n.i18n.translate('xpack.securitySolution.eventFilters.deleteSuccess', {
    defaultMessage: '"{itemName}" has been removed from event filters list.',
    values: {
      itemName
    }
  }),
  emptyStateTitleNoEntries: _i18n.i18n.translate('xpack.securitySolution.eventFilters.emptyStateTitleNoEntries', {
    defaultMessage: 'There are no event filters to display.'
  }),
  emptyStateTitle: _i18n.i18n.translate('xpack.securitySolution.eventFilters.emptyStateTitle', {
    defaultMessage: 'Add your first event filter'
  }),
  emptyStateInfo: _i18n.i18n.translate('xpack.securitySolution.eventFilters.emptyStateInfo', {
    defaultMessage: 'Add an event filter to exclude high volume or unwanted events from being written to Elasticsearch.'
  }),
  emptyStatePrimaryButtonLabel: _i18n.i18n.translate('xpack.securitySolution.eventFilters.emptyStatePrimaryButtonLabel', {
    defaultMessage: 'Add event filter'
  }),
  searchPlaceholderInfo: _i18n.i18n.translate('xpack.securitySolution.eventFilters.searchPlaceholderInfo', {
    defaultMessage: 'Search on the fields below: name, description, comments, value'
  })
};
const EventFiltersList = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    canWriteEventFilters
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const http = (0, _kibana.useHttp)();
  const eventFiltersApiClient = _api_client.EventFiltersApiClient.getInstance(http);
  return /*#__PURE__*/_react.default.createElement(_artifact_list_page.ArtifactListPage, {
    apiClient: eventFiltersApiClient,
    ArtifactFormComponent: _form.EventFiltersForm,
    labels: EVENT_FILTERS_PAGE_LABELS,
    "data-test-subj": "EventFiltersListPage",
    searchableFields: _constants.SEARCHABLE_FIELDS,
    flyoutSize: "l",
    allowCardCreateAction: canWriteEventFilters,
    allowCardEditAction: canWriteEventFilters,
    allowCardDeleteAction: canWriteEventFilters
  });
});
exports.EventFiltersList = EventFiltersList;
EventFiltersList.displayName = 'EventFiltersList';