"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.endpointListReducer = void 0;
var _selectors = require("./selectors");
var _builders = require("./builders");
var _state = require("../../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const handleEndpointPendingActionsStateChanged = (state, action) => {
  if ((0, _selectors.isOnEndpointPage)(state)) {
    return {
      ...state,
      endpointPendingActions: action.payload
    };
  }
  return state;
};
const handleEndpointPackageInfoStateChanged = (state, action) => {
  return {
    ...state,
    endpointPackageInfo: action.payload
  };
};
const handleMetadataTransformStatsChanged = (state, action) => ({
  ...state,
  metadataTransformStats: action.payload
});

/* eslint-disable-next-line complexity */
const endpointListReducer = (state = (0, _builders.initialEndpointPageState)(), action) => {
  if (action.type === 'serverReturnedEndpointList') {
    const {
      data,
      total,
      page,
      pageSize
    } = action.payload;
    return {
      ...state,
      hosts: data,
      total,
      pageIndex: page,
      pageSize,
      loading: false,
      error: undefined
    };
  } else if (action.type === 'serverFailedToReturnEndpointList') {
    return {
      ...state,
      error: action.payload,
      loading: false
    };
  } else if (action.type === 'serverReturnedEndpointNonExistingPolicies') {
    return {
      ...state,
      nonExistingPolicies: {
        ...state.nonExistingPolicies,
        ...action.payload
      }
    };
  } else if (action.type === 'serverReturnedEndpointAgentPolicies') {
    return {
      ...state,
      agentPolicies: {
        ...state.agentPolicies,
        ...action.payload
      }
    };
  } else if (action.type === 'serverReturnedMetadataPatterns') {
    // handle error case
    return {
      ...state,
      patterns: action.payload,
      patternsError: undefined
    };
  } else if (action.type === 'serverFailedToReturnMetadataPatterns') {
    return {
      ...state,
      patternsError: action.payload
    };
  } else if (action.type === 'serverReturnedEndpointDetails') {
    return {
      ...state,
      endpointDetails: {
        ...state.endpointDetails,
        hostInfo: action.payload,
        hostDetails: {
          ...state.endpointDetails.hostDetails,
          details: action.payload.metadata,
          detailsLoading: false,
          detailsError: undefined
        }
      },
      policyVersionInfo: action.payload.policy_info,
      hostStatus: action.payload.host_status
    };
  } else if (action.type === 'serverFailedToReturnEndpointDetails') {
    return {
      ...state,
      endpointDetails: {
        ...state.endpointDetails,
        hostDetails: {
          ...state.endpointDetails.hostDetails,
          detailsError: action.payload,
          detailsLoading: false
        }
      }
    };
  } else if (action.type === 'endpointPendingActionsStateChanged') {
    return handleEndpointPendingActionsStateChanged(state, action);
  } else if (action.type === 'serverReturnedPoliciesForOnboarding') {
    return {
      ...state,
      policyItems: action.payload.policyItems,
      policyItemsLoading: false
    };
  } else if (action.type === 'serverFailedToReturnPoliciesForOnboarding') {
    return {
      ...state,
      error: action.payload,
      policyItemsLoading: false
    };
  } else if (action.type === 'serverReturnedEndpointPolicyResponse') {
    return {
      ...state,
      policyResponse: action.payload.policy_response,
      policyResponseLoading: false,
      policyResponseError: undefined
    };
  } else if (action.type === 'serverFailedToReturnEndpointPolicyResponse') {
    return {
      ...state,
      policyResponseError: action.payload,
      policyResponseLoading: false
    };
  } else if (action.type === 'userSelectedEndpointPolicy') {
    return {
      ...state,
      selectedPolicyId: action.payload.selectedPolicyId,
      policyResponseLoading: false
    };
  } else if (action.type === 'serverCancelledEndpointListLoading') {
    return {
      ...state,
      loading: false
    };
  } else if (action.type === 'serverCancelledPolicyItemsLoading') {
    return {
      ...state,
      policyItemsLoading: false
    };
  } else if (action.type === 'endpointPackageInfoStateChanged') {
    return handleEndpointPackageInfoStateChanged(state, action);
  } else if (action.type === 'serverReturnedEndpointExistValue') {
    return {
      ...state,
      endpointsExist: action.payload
    };
  } else if (action.type === 'serverReturnedAgenstWithEndpointsTotal') {
    return {
      ...state,
      agentsWithEndpointsTotal: action.payload,
      agentsWithEndpointsTotalError: undefined
    };
  } else if (action.type === 'serverFailedToReturnAgenstWithEndpointsTotal') {
    return {
      ...state,
      agentsWithEndpointsTotalError: action.payload
    };
  } else if (action.type === 'serverReturnedEndpointsTotal') {
    return {
      ...state,
      endpointsTotal: action.payload,
      endpointsTotalError: undefined
    };
  } else if (action.type === 'serverFailedToReturnEndpointsTotal') {
    return {
      ...state,
      endpointsTotalError: action.payload
    };
  } else if (action.type === 'userUpdatedEndpointListRefreshOptions') {
    var _action$payload$isAut, _action$payload$autoR;
    return {
      ...state,
      isAutoRefreshEnabled: (_action$payload$isAut = action.payload.isAutoRefreshEnabled) !== null && _action$payload$isAut !== void 0 ? _action$payload$isAut : state.isAutoRefreshEnabled,
      autoRefreshInterval: (_action$payload$autoR = action.payload.autoRefreshInterval) !== null && _action$payload$autoR !== void 0 ? _action$payload$autoR : state.autoRefreshInterval
    };
  } else if (action.type === 'endpointIsolationRequestStateChange') {
    return handleEndpointIsolationRequestStateChanged(state, action);
  } else if (action.type === 'userChangedUrl') {
    const newState = {
      ...state,
      location: action.payload
    };
    const isCurrentlyOnListPage = (0, _selectors.isOnEndpointPage)(newState) && !(0, _selectors.hasSelectedEndpoint)(newState);
    const wasPreviouslyOnListPage = (0, _selectors.isOnEndpointPage)(state) && !(0, _selectors.hasSelectedEndpoint)(state);
    const isCurrentlyOnDetailsPage = (0, _selectors.isOnEndpointPage)(newState) && (0, _selectors.hasSelectedEndpoint)(newState);
    const wasPreviouslyOnDetailsPage = (0, _selectors.isOnEndpointPage)(state) && (0, _selectors.hasSelectedEndpoint)(state);
    const wasPreviouslyOnActivityLogPage = (0, _selectors.isOnEndpointPage)(state) && (0, _selectors.hasSelectedEndpoint)(state) && (0, _selectors.getIsOnEndpointDetailsActivityLog)(state);
    const isCurrentlyOnActivityLogPage = (0, _selectors.isOnEndpointPage)(newState) && (0, _selectors.hasSelectedEndpoint)(newState) && (0, _selectors.getIsOnEndpointDetailsActivityLog)(newState);
    const isNotLoadingDetails = isCurrentlyOnActivityLogPage || wasPreviouslyOnActivityLogPage && (0, _selectors.uiQueryParams)(state).selected_endpoint === (0, _selectors.uiQueryParams)(newState).selected_endpoint;
    const stateUpdates = {
      location: action.payload,
      error: undefined,
      policyResponseError: undefined
    };

    // Reset `isolationRequestState` if needed
    if ((0, _selectors.uiQueryParams)(newState).show !== 'isolate' && !(0, _state.isUninitialisedResourceState)((0, _selectors.getCurrentIsolationRequestState)(newState))) {
      stateUpdates.isolationRequestState = (0, _state.createUninitialisedResourceState)();
    }

    // if on the endpoint list page for the first time, return new location and load list
    if (isCurrentlyOnListPage) {
      if (!wasPreviouslyOnListPage) {
        return {
          ...state,
          ...stateUpdates,
          endpointDetails: {
            ...state.endpointDetails,
            hostDetails: {
              ...state.endpointDetails.hostDetails,
              detailsError: undefined
            }
          },
          loading: true,
          policyItemsLoading: true
        };
      }
    } else if (isCurrentlyOnDetailsPage) {
      // if previous page was the list or another endpoint details page, load endpoint details only
      if (wasPreviouslyOnDetailsPage || wasPreviouslyOnListPage) {
        return {
          ...state,
          ...stateUpdates,
          endpointDetails: {
            ...state.endpointDetails,
            hostDetails: {
              ...state.endpointDetails.hostDetails,
              detailsLoading: !isNotLoadingDetails,
              detailsError: undefined
            }
          },
          detailsLoading: true,
          policyResponseLoading: true
        };
      } else {
        // if previous page was not endpoint list or endpoint details, load both list and details
        return {
          ...state,
          ...stateUpdates,
          endpointDetails: {
            ...state.endpointDetails,
            hostDetails: {
              ...state.endpointDetails.hostDetails,
              detailsLoading: true,
              detailsError: undefined
            }
          },
          loading: true,
          policyResponseLoading: true,
          policyItemsLoading: true
        };
      }
    }
    // otherwise we are not on a endpoint list or details page
    return {
      ...state,
      ...stateUpdates,
      endpointDetails: {
        ...state.endpointDetails,
        hostDetails: {
          ...state.endpointDetails.hostDetails,
          detailsError: undefined
        }
      },
      endpointsExist: true
    };
  } else if (action.type === 'metadataTransformStatsChanged') {
    return handleMetadataTransformStatsChanged(state, action);
  }
  return state;
};
exports.endpointListReducer = endpointListReducer;
const handleEndpointIsolationRequestStateChanged = (state, action) => {
  return {
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    ...state,
    isolationRequestState: action.payload
  };
};