"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetAutomatedActionResponseList = exports.useGetAutomatedActionList = void 0;
var _reactQuery = require("@tanstack/react-query");
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _constants = require("../../../../common/endpoint/constants");
var _expand_dotted = require("../../../../common/utils/expand_dotted");
var _types = require("../../../../common/search_strategy/endpoint/response_actions/types");
var _response_actions = require("../../../../common/search_strategy/endpoint/response_actions");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Make sure we keep this and ACTIONS_QUERY_KEY in osquery_flyout.tsx in sync.
const ACTIONS_QUERY_KEY = 'actions';
const useGetAutomatedActionList = (query, {
  enabled
}) => {
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const {
    alertIds
  } = query;
  return (0, _reactQuery.useQuery)({
    queryKey: [ACTIONS_QUERY_KEY, {
      alertId: alertIds[0]
    }],
    queryFn: async () => {
      const responseData = await (0, _rxjs.lastValueFrom)(data.search.search({
        alertIds,
        sort: {
          order: _types.SortOrder.desc,
          field: '@timestamp'
        },
        factoryQueryType: _response_actions.ResponseActionsQueries.actions
      }, {
        strategy: _constants.ENDPOINT_SEARCH_STRATEGY
      }));

      // fields have to firstly be expanded from dotted object to kind of normal nested object
      const items = (0, _lodash.map)((0, _lodash.filter)(responseData.edges, 'fields'), edge => {
        return (0, _expand_dotted.expandDottedObject)(edge.fields, true);
      });
      return {
        ...responseData,
        items: (0, _lodash.compact)(items)
      };
    },
    enabled,
    keepPreviousData: true
  });
};
exports.useGetAutomatedActionList = useGetAutomatedActionList;
const useGetAutomatedActionResponseList = (query, {
  enabled,
  action: requestAction,
  isLive = false
}) => {
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const {
    expiration,
    actionId,
    agent
  } = query;
  return (0, _reactQuery.useQuery)({
    queryKey: ['allResponsesResults', {
      actionId
    }],
    queryFn: async () => {
      var _responseData$edges$;
      const responseData = await (0, _rxjs.lastValueFrom)(data.search.search({
        actionId,
        expiration,
        sort: {
          order: _types.SortOrder.desc,
          field: '@timestamp'
        },
        agents: (Array.isArray(agent.id) ? agent.id : [agent.id]).length,
        factoryQueryType: _response_actions.ResponseActionsQueries.results
      }, {
        strategy: _constants.ENDPOINT_SEARCH_STRATEGY
      }));
      const action = (_responseData$edges$ = responseData.edges[0]) === null || _responseData$edges$ === void 0 ? void 0 : _responseData$edges$._source;
      return {
        action_id: actionId,
        completedAt: action === null || action === void 0 ? void 0 : action.EndpointActions.completed_at,
        isExpired: responseData.isExpired,
        wasSuccessful: responseData.wasSuccessful,
        isCompleted: responseData.isCompleted,
        status: responseData.status
      };
    },
    select: response => combineResponse(requestAction, response),
    keepPreviousData: true,
    enabled,
    refetchInterval: isLive ? 5000 : false
  });
};
exports.useGetAutomatedActionResponseList = useGetAutomatedActionResponseList;
const combineResponse = (action, responseData) => {
  var _action$rule;
  const {
    rule
  } = action;
  const {
    parameters,
    alert_id: alertId,
    comment,
    command,
    hosts
  } = action.EndpointActions.data;
  return {
    id: action.EndpointActions.action_id,
    agents: action.agent.id,
    parameters,
    ...(alertId !== null && alertId !== void 0 && alertId.length ? {
      alertIds: alertId
    } : {}),
    ...(rule ? {
      ruleId: rule.id,
      ruleName: rule.name
    } : {}),
    createdBy: ((_action$rule = action.rule) === null || _action$rule === void 0 ? void 0 : _action$rule.name) || 'unknown',
    comment,
    command,
    hosts,
    startedAt: action['@timestamp'],
    completedAt: responseData === null || responseData === void 0 ? void 0 : responseData.completedAt,
    isCompleted: !!(responseData !== null && responseData !== void 0 && responseData.isCompleted),
    isExpired: !!(responseData !== null && responseData !== void 0 && responseData.isExpired),
    wasSuccessful: !!(responseData !== null && responseData !== void 0 && responseData.isCompleted),
    status: responseData.status,
    agentState: {},
    errors: action.error ? [action.error.message] : undefined
  };
};