"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _cypressConfig = require("@kbn/cypress-config");
var _data_loaders = require("./cypress/support/data_loaders");
var _response_actions = require("./cypress/support/response_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// eslint-disable-next-line @kbn/imports/no_boundary_crossing
// eslint-disable-next-line @kbn/imports/no_boundary_crossing
// eslint-disable-next-line import/no-default-export
var _default = (0, _cypressConfig.defineCypressConfig)({
  defaultCommandTimeout: 60000,
  execTimeout: 120000,
  pageLoadTimeout: 12000,
  retries: {
    runMode: 1,
    openMode: 0
  },
  screenshotsFolder: '../../../target/kibana-security-solution/public/management/cypress/screenshots',
  trashAssetsBeforeRuns: false,
  video: false,
  viewportHeight: 900,
  viewportWidth: 1440,
  experimentalStudio: true,
  env: {
    'cypress-react-selector': {
      root: '#security-solution-app'
    }
  },
  e2e: {
    baseUrl: 'http://localhost:5620',
    supportFile: 'public/management/cypress/support/e2e.ts',
    specPattern: 'public/management/cypress/e2e/endpoint/*.cy.{js,jsx,ts,tsx}',
    experimentalRunAllSpecs: true,
    setupNodeEvents: (on, config) => {
      (0, _data_loaders.dataLoaders)(on, config);
      // Data loaders specific to "real" Endpoint testing
      (0, _data_loaders.dataLoadersForRealEndpoints)(on, config);
      (0, _response_actions.responseActionTasks)(on, config);
    }
  }
});
exports.default = _default;
module.exports = exports.default;