"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HELP_LABEL = exports.ConsoleHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_data_test_subj = require("../hooks/state_selectors/use_data_test_subj");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _use_console_state_dispatch = require("../hooks/state_selectors/use_console_state_dispatch");
var _use_with_side_panel = require("../hooks/state_selectors/use_with_side_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HELP_LABEL = _i18n.i18n.translate('xpack.securitySolution.console.layoutHeader.helpButtonTitle', {
  defaultMessage: 'Help'
});
exports.HELP_LABEL = HELP_LABEL;
const HELP_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.console.layoutHeader.helpButtonLabel', {
  defaultMessage: 'Show help'
});
const StyledEuiButtonEmpty = (0, _styledComponents.default)(_eui.EuiButtonEmpty)`
  margin-left: auto;
  height: inherit;
`;
const ConsoleHeader = /*#__PURE__*/(0, _react.memo)(({
  TitleComponent
}) => {
  const dispatch = (0, _use_console_state_dispatch.useConsoleStateDispatch)();
  const panelCurrentlyShowing = (0, _use_with_side_panel.useWithSidePanel)().show;
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)('header'));
  const isHelpOpen = panelCurrentlyShowing === 'help';
  const handleHelpButtonOnClick = (0, _react.useCallback)(() => {
    dispatch({
      type: 'showSidePanel',
      payload: {
        show: isHelpOpen ? null : 'help'
      }
    });
  }, [dispatch, isHelpOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    justifyContent: "spaceBetween",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    className: "eui-textTruncate noThemeOverrides",
    "data-test-subj": getTestId('titleComponentContainer')
  }, TitleComponent ? /*#__PURE__*/_react.default.createElement(TitleComponent, null) : ''), !isHelpOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(StyledEuiButtonEmpty, {
    style: {
      marginLeft: 'auto'
    },
    onClick: handleHelpButtonOnClick,
    iconType: "help",
    title: HELP_TOOLTIP,
    "aria-label": HELP_TOOLTIP,
    isSelected: isHelpOpen,
    "data-test-subj": getTestId('helpButton')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.console.layoutHeader.helpButtonTitle",
    defaultMessage: "Help"
  }))));
});
exports.ConsoleHeader = ConsoleHeader;
ConsoleHeader.displayName = 'ConsoleHeader';