"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CardComments = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _get_formatted_comments = require("../utils/get_formatted_comments");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CardComments = /*#__PURE__*/(0, _react.memo)(({
  comments,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const [showComments, setShowComments] = (0, _react.useState)(false);
  const onCommentsClick = (0, _react.useCallback)(() => {
    setShowComments(!showComments);
  }, [setShowComments, showComments]);
  const formattedComments = (0, _react.useMemo)(() => {
    return (0, _get_formatted_comments.getFormattedComments)(comments);
  }, [comments]);
  const buttonText = (0, _react.useMemo)(() => showComments ? (0, _translations.HIDE_COMMENTS_LABEL)(comments.length) : (0, _translations.SHOW_COMMENTS_LABEL)(comments.length), [comments.length, showComments]);
  return !(0, _fp.isEmpty)(comments) ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCommentsClick,
    flush: "left",
    size: "xs",
    "data-test-subj": getTestId('label')
  }, buttonText), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: '1',
    arrowDisplay: "none",
    forceState: showComments ? 'open' : 'closed'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCommentList, {
    comments: formattedComments,
    "data-test-subj": getTestId('list')
  }))) : null;
});
exports.CardComments = CardComments;
CardComments.displayName = 'CardComments';