"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArtifactEntryCollapsibleCard = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _card_container_panel = require("./components/card_container_panel");
var _use_normalized_artifact = require("./hooks/use_normalized_artifact");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _card_section_panel = require("./components/card_section_panel");
var _criteria_conditions = require("./components/criteria_conditions");
var _card_compressed_header = require("./components/card_compressed_header");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ArtifactEntryCollapsibleCard = /*#__PURE__*/(0, _react.memo)(({
  item,
  onExpandCollapse,
  policies,
  actions,
  expanded = false,
  'data-test-subj': dataTestSubj,
  ...commonProps
}) => {
  const artifact = (0, _use_normalized_artifact.useNormalizedArtifact)(item);
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  return /*#__PURE__*/_react.default.createElement(_card_container_panel.CardContainerPanel, (0, _extends2.default)({}, commonProps, {
    "data-test-subj": dataTestSubj
  }), /*#__PURE__*/_react.default.createElement(_card_section_panel.CardSectionPanel, {
    className: "artifact-entry-collapsible-card"
  }, /*#__PURE__*/_react.default.createElement(_card_compressed_header.CardCompressedHeader, {
    artifact: artifact,
    actions: actions,
    policies: policies,
    expanded: expanded,
    onExpandCollapse: onExpandCollapse,
    "data-test-subj": getTestId('header')
  })), expanded && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_card_section_panel.CardSectionPanel, null, /*#__PURE__*/_react.default.createElement(_criteria_conditions.CriteriaConditions, {
    os: artifact.os,
    entries: artifact.entries,
    "data-test-subj": getTestId('criteriaConditions')
  }))));
});
exports.ArtifactEntryCollapsibleCard = ArtifactEntryCollapsibleCard;
ArtifactEntryCollapsibleCard.displayName = 'ArtifactEntryCollapsibleCard';