"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFetchData = exports.AGG_KEY = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AGG_KEY = 'aggregation';

/**
 * Interface for aggregation responses
 */
exports.AGG_KEY = AGG_KEY;
/**
 * Reusable method that returns a promise wrapping the search functionality of Kibana search service
 */
const createFetchData = async (searchService, req) => {
  return new Promise((resolve, reject) => {
    searchService.search(req).subscribe({
      next: response => {
        resolve(response.rawResponse);
      },
      error: error => {
        reject(error);
      }
    });
  });
};
exports.createFetchData = createFetchData;