"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShowRelatedAlertsBySession = void 0;
var _fp = require("lodash/fp");
var _helpers = require("../../../common/components/event_details/insights/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns true if document has process.entry_leader.entity_id field with values
 */
const useShowRelatedAlertsBySession = ({
  dataFormattedForFieldBrowser
}) => {
  const processSessionField = (0, _fp.find)({
    category: 'process',
    field: 'process.entry_leader.entity_id'
  }, dataFormattedForFieldBrowser);
  return (0, _helpers.hasData)(processSessionField);
};
exports.useShowRelatedAlertsBySession = useShowRelatedAlertsBySession;