"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShowRelatedAlertsBySameSourceEvent = void 0;
var _fp = require("lodash/fp");
var _helpers = require("../../../common/components/event_details/insights/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns true if document has kibana.alert.original.event.id field with values
 */
const useShowRelatedAlertsBySameSourceEvent = ({
  dataFormattedForFieldBrowser
}) => {
  const sourceEventField = (0, _fp.find)({
    category: 'kibana',
    field: 'kibana.alert.original_event.id'
  }, dataFormattedForFieldBrowser);
  return (0, _helpers.hasData)(sourceEventField);
};
exports.useShowRelatedAlertsBySameSourceEvent = useShowRelatedAlertsBySameSourceEvent;