"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShowRelatedAlertsByAncestry = void 0;
var _fp = require("lodash/fp");
var _investigate_in_resolver = require("../../../detections/components/alerts_table/timeline_actions/investigate_in_resolver");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _use_license = require("../../../common/hooks/use_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns true if the user has at least platinum privilege, and if the document has ancestry data
 */
const useShowRelatedAlertsByAncestry = ({
  dataFormattedForFieldBrowser,
  dataAsNestedObject
}) => {
  const isRelatedAlertsByProcessAncestryEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('insightsRelatedAlertsByProcessAncestry');
  const hasProcessEntityInfo = (0, _investigate_in_resolver.isInvestigateInResolverActionEnabled)(dataAsNestedObject || undefined);
  const originalDocumentId = (0, _fp.find)({
    category: 'kibana',
    field: 'kibana.alert.ancestors.id'
  }, dataFormattedForFieldBrowser);
  const originalDocumentIndex = (0, _fp.find)({
    category: 'kibana',
    field: 'kibana.alert.rule.parameters.index'
  }, dataFormattedForFieldBrowser);
  const canShowAncestryInsight = isRelatedAlertsByProcessAncestryEnabled && hasProcessEntityInfo && originalDocumentId && originalDocumentIndex;
  const hasAtLeastPlatinum = (0, _use_license.useLicense)().isPlatinumPlus();
  return canShowAncestryInsight != null && canShowAncestryInsight && hasAtLeastPlatinum;
};
exports.useShowRelatedAlertsByAncestry = useShowRelatedAlertsByAncestry;