"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchRelatedAlertsByAncestry = void 0;
var _fp = require("lodash/fp");
var _react = require("react");
var _use_alert_prevalence_from_process_tree = require("../../../common/containers/alerts/use_alert_prevalence_from_process_tree");
var _helpers = require("../../../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieves all alert related by ancestry then returns a loading, error, data and count interface.
 * This uses the kibana.alert.ancestors.id and kibana.alert.rule.parameters.index fields.
 */
const useFetchRelatedAlertsByAncestry = ({
  dataFormattedForFieldBrowser,
  scopeId
}) => {
  const documentId = (0, _react.useMemo)(() => {
    const originalDocumentId = (0, _fp.find)({
      category: 'kibana',
      field: 'kibana.alert.ancestors.id'
    }, dataFormattedForFieldBrowser);
    const {
      values
    } = originalDocumentId !== null && originalDocumentId !== void 0 ? originalDocumentId : {
      values: []
    };
    return Array.isArray(values) ? values[0] : '';
  }, [dataFormattedForFieldBrowser]);
  const {
    values: indices
  } = (0, _react.useMemo)(() => (0, _fp.find)({
    category: 'kibana',
    field: 'kibana.alert.rule.parameters.index'
  }, dataFormattedForFieldBrowser) || {
    values: []
  }, [dataFormattedForFieldBrowser]);
  const isActiveTimelines = (0, _helpers.isActiveTimeline)(scopeId !== null && scopeId !== void 0 ? scopeId : '');
  const {
    loading,
    error,
    alertIds
  } = (0, _use_alert_prevalence_from_process_tree.useAlertPrevalenceFromProcessTree)({
    isActiveTimeline: isActiveTimelines,
    documentId,
    indices: indices || []
  });
  return (0, _react.useMemo)(() => ({
    loading,
    error,
    data: alertIds,
    dataCount: (alertIds === null || alertIds === void 0 ? void 0 : alertIds.length) || 0
  }), [alertIds, error, loading]);
};
exports.useFetchRelatedAlertsByAncestry = useFetchRelatedAlertsByAncestry;