"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCorrelations = void 0;
var _react = require("react");
var _use_fetch_related_alerts_by_same_source_event = require("./use_fetch_related_alerts_by_same_source_event");
var _use_show_related_cases = require("./use_show_related_cases");
var _use_fetch_related_cases = require("./use_fetch_related_cases");
var _translations = require("../translations");
var _use_show_related_alerts_by_ancestry = require("./use_show_related_alerts_by_ancestry");
var _use_fetch_related_alerts_by_ancestry = require("./use_fetch_related_alerts_by_ancestry");
var _use_show_related_alerts_by_same_source_event = require("./use_show_related_alerts_by_same_source_event");
var _use_show_related_alerts_by_session = require("./use_show_related_alerts_by_session");
var _use_fetch_related_alerts_by_session = require("./use_fetch_related_alerts_by_session");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieves all correlations data from custom hooks
 */
const useCorrelations = ({
  eventId,
  dataAsNestedObject,
  dataFormattedForFieldBrowser,
  scopeId
}) => {
  const [data, updateInsightsSummaryPanel] = (0, _react.useReducer)((currentEntries, newEntry) => {
    return [...currentEntries, newEntry];
  }, []);

  // cases
  const showCases = (0, _use_show_related_cases.useShowRelatedCases)();
  const {
    loading: casesLoading,
    error: casesError,
    dataCount: casesCount,
    data: cases
  } = (0, _use_fetch_related_cases.useFetchRelatedCases)({
    eventId
  });
  (0, _react.useEffect)(() => {
    if (showCases && !casesLoading && !casesError) {
      updateInsightsSummaryPanel({
        icon: 'warning',
        value: casesCount,
        text: casesCount <= 1 ? _translations.CORRELATIONS_RELATED_CASE : _translations.CORRELATIONS_RELATED_CASES
      });
    }
  }, [casesCount, casesError, casesLoading, showCases]);

  // alerts by ancestry
  const showAlertsByAncestry = (0, _use_show_related_alerts_by_ancestry.useShowRelatedAlertsByAncestry)({
    dataFormattedForFieldBrowser,
    dataAsNestedObject
  });
  const {
    loading: ancestryAlertsLoading,
    error: ancestryAlertsError,
    dataCount: ancestryAlertsCount,
    data: ancestryAlertsIds
  } = (0, _use_fetch_related_alerts_by_ancestry.useFetchRelatedAlertsByAncestry)({
    dataFormattedForFieldBrowser,
    scopeId
  });
  (0, _react.useEffect)(() => {
    if (showAlertsByAncestry && !ancestryAlertsLoading && !ancestryAlertsError) {
      updateInsightsSummaryPanel({
        icon: 'warning',
        value: ancestryAlertsCount,
        text: ancestryAlertsCount <= 1 ? _translations.CORRELATIONS_ANCESTRY_ALERT : _translations.CORRELATIONS_ANCESTRY_ALERTS
      });
    }
  }, [ancestryAlertsCount, ancestryAlertsError, ancestryAlertsLoading, showAlertsByAncestry]);

  // alerts related to same source event
  const showSameSourceAlerts = (0, _use_show_related_alerts_by_same_source_event.useShowRelatedAlertsBySameSourceEvent)({
    dataFormattedForFieldBrowser
  });
  const {
    loading: sameSourceAlertsLoading,
    error: sameSourceAlertsError,
    dataCount: sameSourceAlertsCount,
    data: sameSourceAlertsIds
  } = (0, _use_fetch_related_alerts_by_same_source_event.useFetchRelatedAlertsBySameSourceEvent)({
    dataFormattedForFieldBrowser,
    scopeId
  });
  (0, _react.useEffect)(() => {
    if (showSameSourceAlerts && !sameSourceAlertsLoading && !sameSourceAlertsError) {
      updateInsightsSummaryPanel({
        icon: 'warning',
        value: sameSourceAlertsCount,
        text: sameSourceAlertsCount <= 1 ? _translations.CORRELATIONS_SAME_SOURCE_EVENT_ALERT : _translations.CORRELATIONS_SAME_SOURCE_EVENT_ALERTS
      });
    }
  }, [sameSourceAlertsCount, sameSourceAlertsError, sameSourceAlertsLoading, showSameSourceAlerts]);

  // alerts related by session
  const showAlertsBySession = (0, _use_show_related_alerts_by_session.useShowRelatedAlertsBySession)({
    dataFormattedForFieldBrowser
  });
  const {
    loading: alertsBySessionLoading,
    error: alertsBySessionError,
    dataCount: alertsBySessionCount,
    data: alertsBySessionIds
  } = (0, _use_fetch_related_alerts_by_session.useFetchRelatedAlertsBySession)({
    dataFormattedForFieldBrowser,
    scopeId
  });
  (0, _react.useEffect)(() => {
    if (showAlertsBySession && !alertsBySessionLoading && !alertsBySessionError) {
      updateInsightsSummaryPanel({
        icon: 'warning',
        value: alertsBySessionCount,
        text: alertsBySessionCount <= 1 ? _translations.CORRELATIONS_SAME_SESSION_ALERT : _translations.CORRELATIONS_SAME_SESSION_ALERTS
      });
    }
  }, [alertsBySessionCount, alertsBySessionError, alertsBySessionLoading, showAlertsBySession]);
  return (0, _react.useMemo)(() => ({
    loading: casesLoading || ancestryAlertsLoading || alertsBySessionLoading || sameSourceAlertsLoading,
    error: data.length === 0,
    data,
    dataCount: data.length || 0,
    alertsBySessionIds,
    sameSourceAlertsIds,
    ancestryAlertsIds: ancestryAlertsIds || [],
    cases
  }), [alertsBySessionIds, alertsBySessionLoading, ancestryAlertsIds, ancestryAlertsLoading, cases, casesLoading, data, sameSourceAlertsIds, sameSourceAlertsLoading]);
};
exports.useCorrelations = useCorrelations;