"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("./translations");
var _translations2 = require("../../shared/translations");
var _types = require("../../../../common/types");
var _event_fields_browser = require("../../../common/components/event_details/event_fields_browser");
var _context = require("../context");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Table view displayed in the document details expandable flyout right section
 */
const TableTab = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    browserFields,
    dataFormattedForFieldBrowser,
    eventId
  } = (0, _context.useRightPanelContext)();
  if (!browserFields || !eventId || !dataFormattedForFieldBrowser) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "error",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, (0, _translations2.ERROR_TITLE)(_translations.DOCUMENT_ERROR_TITLE)),
      body: /*#__PURE__*/_react.default.createElement("p", null, (0, _translations2.ERROR_MESSAGE)(_translations.DOCUMENT_ERROR_DETAILS)),
      "data-test-subj": _test_ids.TABLE_TAB_ERROR_TEST_ID
    });
  }
  return /*#__PURE__*/_react.default.createElement(_event_fields_browser.EventFieldsBrowser, {
    browserFields: browserFields,
    data: dataFormattedForFieldBrowser,
    eventId: eventId,
    isDraggable: false,
    timelineTabType: _types.TimelineTabs.query,
    scopeId: 'alert-details-flyout',
    isReadOnly: false
  });
});
exports.TableTab = TableTab;
TableTab.displayName = 'TableTab';