"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePrevalence = void 0;
var _react = _interopRequireWildcard(require("react"));
var _get_alert_summary_rows = require("../../../common/components/event_details/get_alert_summary_rows");
var _prevalence_overview_row = require("../components/prevalence_overview_row");
var _test_ids = require("../components/test_ids");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This hook retrieves the highlighted fields from the {@link getSummaryRows} method, then iterates through them
 * and generate a {@link PrevalenceOverviewRow} for each.
 * We use a callback method passed down to the {@link PrevalenceOverviewRow} component to know when it's rendered as null.
 * We need to let the parent know when all the {@link PrevalenceOverviewRow} are null, so it can hide then entire section.
 */
const usePrevalence = ({
  eventId,
  browserFields,
  dataFormattedForFieldBrowser,
  scopeId
}) => {
  const [count, setCount] = (0, _react.useState)(0); // TODO this needs to be changed at it causes a re-render when the count is updated

  // retrieves the highlighted fields
  const summaryRows = (0, _react.useMemo)(() => (0, _get_alert_summary_rows.getSummaryRows)({
    browserFields: browserFields || {},
    data: dataFormattedForFieldBrowser || [],
    eventId,
    scopeId,
    isReadOnly: false
  }), [browserFields, dataFormattedForFieldBrowser, eventId, scopeId]);
  const prevalenceRows = (0, _react.useMemo)(() => summaryRows.map(row => {
    const highlightedField = {
      name: row.description.data.field,
      values: row.description.values || []
    };
    return /*#__PURE__*/_react.default.createElement(_prevalence_overview_row.PrevalenceOverviewRow, {
      highlightedField: highlightedField,
      scopeId: scopeId,
      callbackIfNull: () => setCount(prevCount => prevCount + 1),
      "data-test-subj": _test_ids.INSIGHTS_PREVALENCE_TEST_ID,
      key: row.description.data.field
    });
  }), [summaryRows, scopeId]);
  return {
    prevalenceRows,
    empty: count >= summaryRows.length
  };
};
exports.usePrevalence = usePrevalence;