"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelHeader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _tabs = require("./tabs");
var _header_title = require("./components/header_title");
var _expand_detail_button = require("./components/expand_detail_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PanelHeader = /*#__PURE__*/(0, _react.memo)(({
  selectedTabId,
  setSelectedTabId,
  handleOnEventClosed
}) => {
  const onSelectedTabChanged = id => setSelectedTabId(id);
  const renderTabs = _tabs.tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => onSelectedTabChanged(tab.id),
    isSelected: tab.id === selectedTabId,
    key: index,
    "data-test-subj": tab['data-test-subj']
  }, tab.name));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    css: (0, _react2.css)`
          margin-bottom: -24px;
        `
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
            margin-top: -24px;
            margin-left: -8px;
          `
  }, /*#__PURE__*/_react.default.createElement(_expand_detail_button.ExpandDetailButton, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_header_title.HeaderTitle, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "l",
    expand: true,
    css: (0, _react2.css)`
            margin-bottom: -25px;
          `
  }, renderTabs));
});
exports.PanelHeader = PanelHeader;
PanelHeader.displayName = 'PanelHeader';