"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VISUALIZATIONS_TITLE = exports.VIEW_RULE_TEXT = exports.VIEW_ALL = exports.THREAT_MATCH_DETECTED = exports.THREAT_MATCHES_DETECTED = exports.THREAT_INTELLIGENCE_TITLE = exports.THREAT_INTELLIGENCE_TEXT = exports.THREAT_ENRICHMENTS = exports.THREAT_ENRICHMENT = exports.TECHNICAL_PREVIEW_TITLE = exports.TECHNICAL_PREVIEW_MESSAGE = exports.SHARE = exports.SEVERITY_TITLE = exports.SESSION_PREVIEW_TITLE = exports.SESSION_PREVIEW_TIME_TEXT = exports.SESSION_PREVIEW_RULE_TEXT = exports.SESSION_PREVIEW_PROCESS_TEXT = exports.SESSION_PREVIEW_COMMAND_TEXT = exports.RULE_DESCRIPTION_TITLE = exports.RISK_SCORE_TITLE = exports.PREVALENCE_TITLE = exports.PREVALENCE_TEXT = exports.PREVALENCE_ROW_UNCOMMON = exports.INVESTIGATION_TITLE = exports.INVESTIGATION_GUIDE_TITLE = exports.INSIGHTS_TITLE = exports.HIGHLIGHTED_FIELDS_TITLE = exports.EXPAND_DETAILS_BUTTON = exports.ENTITIES_TITLE = exports.ENTITIES_TEXT = exports.DOCUMENT_REASON_TITLE = exports.DOCUMENT_DETAILS = exports.DOCUMENT_DESCRIPTION_TITLE = exports.DOCUMENT_DESCRIPTION_EXPAND_BUTTON = exports.DOCUMENT_DESCRIPTION_COLLAPSE_BUTTON = exports.DESCRIPTION_TITLE = exports.CORRELATIONS_TITLE = exports.CORRELATIONS_TEXT = exports.CORRELATIONS_SAME_SOURCE_EVENT_ALERTS = exports.CORRELATIONS_SAME_SOURCE_EVENT_ALERT = exports.CORRELATIONS_SAME_SESSION_ALERTS = exports.CORRELATIONS_SAME_SESSION_ALERT = exports.CORRELATIONS_RELATED_CASES = exports.CORRELATIONS_RELATED_CASE = exports.CORRELATIONS_ANCESTRY_ALERTS = exports.CORRELATIONS_ANCESTRY_ALERT = exports.COLLAPSE_DETAILS_BUTTON = exports.ANALYZER_PREVIEW_TITLE = exports.ANALYZER_PREVIEW_TEXT = exports.ALERT_REASON_TITLE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* Header */

const EXPAND_DETAILS_BUTTON = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.expandDetailButton', {
  defaultMessage: 'Expand alert details'
});
exports.EXPAND_DETAILS_BUTTON = EXPAND_DETAILS_BUTTON;
const COLLAPSE_DETAILS_BUTTON = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.collapseDetailButton', {
  defaultMessage: 'Collapse alert details'
});
exports.COLLAPSE_DETAILS_BUTTON = COLLAPSE_DETAILS_BUTTON;
const DOCUMENT_DETAILS = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.headerTitle', {
  defaultMessage: 'Document details'
});
exports.DOCUMENT_DETAILS = DOCUMENT_DETAILS;
const SEVERITY_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.severityTitle', {
  defaultMessage: 'Severity'
});
exports.SEVERITY_TITLE = SEVERITY_TITLE;
const RISK_SCORE_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.riskScoreTitle', {
  defaultMessage: 'Risk score'
});
exports.RISK_SCORE_TITLE = RISK_SCORE_TITLE;
const VIEW_RULE_TEXT = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.viewRuleText', {
  defaultMessage: 'View rule'
});

/* Description section */
exports.VIEW_RULE_TEXT = VIEW_RULE_TEXT;
const DESCRIPTION_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.descriptionTitle', {
  defaultMessage: 'Description'
});
exports.DESCRIPTION_TITLE = DESCRIPTION_TITLE;
const RULE_DESCRIPTION_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.ruleDescriptionTitle', {
  defaultMessage: 'Rule description'
});
exports.RULE_DESCRIPTION_TITLE = RULE_DESCRIPTION_TITLE;
const DOCUMENT_DESCRIPTION_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.documentDescriptionTitle', {
  defaultMessage: 'Document description'
});
exports.DOCUMENT_DESCRIPTION_TITLE = DOCUMENT_DESCRIPTION_TITLE;
const DOCUMENT_DESCRIPTION_EXPAND_BUTTON = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.documentDescriptionExpandButton', {
  defaultMessage: 'Expand'
});
exports.DOCUMENT_DESCRIPTION_EXPAND_BUTTON = DOCUMENT_DESCRIPTION_EXPAND_BUTTON;
const DOCUMENT_DESCRIPTION_COLLAPSE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.documentDescriptionCollapseButton', {
  defaultMessage: 'Collapse'
});
exports.DOCUMENT_DESCRIPTION_COLLAPSE_BUTTON = DOCUMENT_DESCRIPTION_COLLAPSE_BUTTON;
const ALERT_REASON_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.alertReasonTitle', {
  defaultMessage: 'Alert reason'
});
exports.ALERT_REASON_TITLE = ALERT_REASON_TITLE;
const DOCUMENT_REASON_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.documentReasonTitle', {
  defaultMessage: 'Document reason'
});

/* Investigation section */
exports.DOCUMENT_REASON_TITLE = DOCUMENT_REASON_TITLE;
const INVESTIGATION_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.investigationSectionTitle', {
  defaultMessage: 'Investigation'
});
exports.INVESTIGATION_TITLE = INVESTIGATION_TITLE;
const HIGHLIGHTED_FIELDS_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.highlightedFieldsTitle', {
  defaultMessage: 'Highlighted fields'
});

/* Insights section */
exports.HIGHLIGHTED_FIELDS_TITLE = HIGHLIGHTED_FIELDS_TITLE;
const ENTITIES_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.entitiesTitle', {
  defaultMessage: 'Entities'
});
exports.ENTITIES_TITLE = ENTITIES_TITLE;
const THREAT_INTELLIGENCE_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.threatIntelligenceTitle', {
  defaultMessage: 'Threat Intelligence'
});
exports.THREAT_INTELLIGENCE_TITLE = THREAT_INTELLIGENCE_TITLE;
const INSIGHTS_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.insightsTitle', {
  defaultMessage: 'Insights'
});
exports.INSIGHTS_TITLE = INSIGHTS_TITLE;
const CORRELATIONS_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.correlationsTitle', {
  defaultMessage: 'Correlations'
});
exports.CORRELATIONS_TITLE = CORRELATIONS_TITLE;
const PREVALENCE_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.prevalenceTitle', {
  defaultMessage: 'Prevalence'
});
exports.PREVALENCE_TITLE = PREVALENCE_TITLE;
const TECHNICAL_PREVIEW_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.technicalPreviewTitle', {
  defaultMessage: 'Technical Preview'
});
exports.TECHNICAL_PREVIEW_TITLE = TECHNICAL_PREVIEW_TITLE;
const TECHNICAL_PREVIEW_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.technicalPreviewMessage', {
  defaultMessage: 'This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will take a best effort approach to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.'
});
exports.TECHNICAL_PREVIEW_MESSAGE = TECHNICAL_PREVIEW_MESSAGE;
const ENTITIES_TEXT = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.entitiesText', {
  defaultMessage: 'entities'
});
exports.ENTITIES_TEXT = ENTITIES_TEXT;
const THREAT_INTELLIGENCE_TEXT = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.threatIntelligenceText', {
  defaultMessage: 'fields of threat intelligence'
});
exports.THREAT_INTELLIGENCE_TEXT = THREAT_INTELLIGENCE_TEXT;
const THREAT_MATCH_DETECTED = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.threatIntelligence.threatMatch', {
  defaultMessage: `threat match detected`
});
exports.THREAT_MATCH_DETECTED = THREAT_MATCH_DETECTED;
const THREAT_MATCHES_DETECTED = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.threatIntelligence.threatMatches', {
  defaultMessage: `threat matches detected`
});
exports.THREAT_MATCHES_DETECTED = THREAT_MATCHES_DETECTED;
const THREAT_ENRICHMENT = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.threatIntelligence.threatEnrichment', {
  defaultMessage: `field enriched with threat intelligence`
});
exports.THREAT_ENRICHMENT = THREAT_ENRICHMENT;
const THREAT_ENRICHMENTS = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.threatIntelligence.threatEnrichments', {
  defaultMessage: `fields enriched with threat intelligence`
});
exports.THREAT_ENRICHMENTS = THREAT_ENRICHMENTS;
const CORRELATIONS_TEXT = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.correlationsText', {
  defaultMessage: 'fields of correlation'
});
exports.CORRELATIONS_TEXT = CORRELATIONS_TEXT;
const CORRELATIONS_ANCESTRY_ALERT = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.correlations.ancestryAlert', {
  defaultMessage: 'alert related by ancestry'
});
exports.CORRELATIONS_ANCESTRY_ALERT = CORRELATIONS_ANCESTRY_ALERT;
const CORRELATIONS_ANCESTRY_ALERTS = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.correlations.ancestryAlerts', {
  defaultMessage: 'alerts related by ancestry'
});
exports.CORRELATIONS_ANCESTRY_ALERTS = CORRELATIONS_ANCESTRY_ALERTS;
const CORRELATIONS_SAME_SOURCE_EVENT_ALERT = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.correlations.sameSourceEventAlert', {
  defaultMessage: 'alert related by the same source event'
});
exports.CORRELATIONS_SAME_SOURCE_EVENT_ALERT = CORRELATIONS_SAME_SOURCE_EVENT_ALERT;
const CORRELATIONS_SAME_SOURCE_EVENT_ALERTS = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.correlations.sameSourceEventAlerts', {
  defaultMessage: 'alerts related by the same source event'
});
exports.CORRELATIONS_SAME_SOURCE_EVENT_ALERTS = CORRELATIONS_SAME_SOURCE_EVENT_ALERTS;
const CORRELATIONS_SAME_SESSION_ALERT = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.correlations.sameSessionAlert', {
  defaultMessage: 'alert related by session'
});
exports.CORRELATIONS_SAME_SESSION_ALERT = CORRELATIONS_SAME_SESSION_ALERT;
const CORRELATIONS_SAME_SESSION_ALERTS = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.correlations.sameSessionAlerts', {
  defaultMessage: 'alerts related by session'
});
exports.CORRELATIONS_SAME_SESSION_ALERTS = CORRELATIONS_SAME_SESSION_ALERTS;
const CORRELATIONS_RELATED_CASE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.correlations.relatedCase', {
  defaultMessage: 'related case'
});
exports.CORRELATIONS_RELATED_CASE = CORRELATIONS_RELATED_CASE;
const CORRELATIONS_RELATED_CASES = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.correlations.relatedCases', {
  defaultMessage: 'related cases'
});
exports.CORRELATIONS_RELATED_CASES = CORRELATIONS_RELATED_CASES;
const PREVALENCE_TEXT = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.prevalenceText', {
  defaultMessage: 'fields of prevalence'
});
exports.PREVALENCE_TEXT = PREVALENCE_TEXT;
const PREVALENCE_ROW_UNCOMMON = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.prevalenceRowText', {
  defaultMessage: 'is uncommon'
});
exports.PREVALENCE_ROW_UNCOMMON = PREVALENCE_ROW_UNCOMMON;
const VIEW_ALL = text => _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.viewAllButton', {
  values: {
    text
  },
  defaultMessage: 'View all {text}'
});
exports.VIEW_ALL = VIEW_ALL;
const VISUALIZATIONS_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.visualizationsTitle', {
  defaultMessage: 'Visualizations'
});
exports.VISUALIZATIONS_TITLE = VISUALIZATIONS_TITLE;
const ANALYZER_PREVIEW_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.analyzerPreviewTitle', {
  defaultMessage: 'Analyzer preview'
});
exports.ANALYZER_PREVIEW_TITLE = ANALYZER_PREVIEW_TITLE;
const ANALYZER_PREVIEW_TEXT = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.analyzerPreviewText', {
  defaultMessage: 'analyzer preview.'
});
exports.ANALYZER_PREVIEW_TEXT = ANALYZER_PREVIEW_TEXT;
const SHARE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.share', {
  defaultMessage: 'Share Alert'
});
exports.SHARE = SHARE;
const INVESTIGATION_GUIDE_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.investigationGuideText', {
  defaultMessage: 'Investigation guide'
});
exports.INVESTIGATION_GUIDE_TITLE = INVESTIGATION_GUIDE_TITLE;
const SESSION_PREVIEW_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.sessionPreview.title', {
  defaultMessage: 'Session viewer preview'
});
exports.SESSION_PREVIEW_TITLE = SESSION_PREVIEW_TITLE;
const SESSION_PREVIEW_PROCESS_TEXT = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.sessionPreview.processText', {
  defaultMessage: 'started'
});
exports.SESSION_PREVIEW_PROCESS_TEXT = SESSION_PREVIEW_PROCESS_TEXT;
const SESSION_PREVIEW_TIME_TEXT = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.sessionPreview.timeText', {
  defaultMessage: 'at'
});
exports.SESSION_PREVIEW_TIME_TEXT = SESSION_PREVIEW_TIME_TEXT;
const SESSION_PREVIEW_RULE_TEXT = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.sessionPreview.ruleText', {
  defaultMessage: 'with rule'
});
exports.SESSION_PREVIEW_RULE_TEXT = SESSION_PREVIEW_RULE_TEXT;
const SESSION_PREVIEW_COMMAND_TEXT = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.sessionPreview.commandText', {
  defaultMessage: 'by'
});
exports.SESSION_PREVIEW_COMMAND_TEXT = SESSION_PREVIEW_COMMAND_TEXT;