"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationGuideButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _context = require("../context");
var _use_rule_with_fallback = require("../../../detection_engine/rule_management/logic/use_rule_with_fallback");
var _helpers = require("../../../timelines/components/side_panel/event_details/helpers");
var _left = require("../../left");
var _test_ids = require("./test_ids");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Investigation guide button that opens Investigation section in the left panel
 */
const InvestigationGuideButton = () => {
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const {
    eventId,
    indexName,
    scopeId,
    dataFormattedForFieldBrowser
  } = (0, _context.useRightPanelContext)();
  const {
    ruleId
  } = (0, _helpers.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const {
    rule: maybeRule
  } = (0, _use_rule_with_fallback.useRuleWithFallback)(ruleId);
  const goToInvestigationsTab = (0, _react.useCallback)(() => {
    openLeftPanel({
      id: _left.LeftPanelKey,
      path: _left.LeftPanelInvestigationTabPath,
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  }, [eventId, indexName, openLeftPanel, scopeId]);
  if (!dataFormattedForFieldBrowser || !ruleId || !(maybeRule !== null && maybeRule !== void 0 && maybeRule.note)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: goToInvestigationsTab,
    iconType: "documentation",
    "data-test-subj": _test_ids.INVESTIGATION_GUIDE_BUTTON_TEST_ID
  }, _translations.INVESTIGATION_GUIDE_TITLE);
};
exports.InvestigationGuideButton = InvestigationGuideButton;
InvestigationGuideButton.displayName = 'InvestigationGuideButton';