"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderTitle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _elasticAssistant = require("@kbn/elastic-assistant");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _use_assistant = require("../hooks/use_assistant");
var _translations = require("../../../common/components/event_details/translations");
var _severity = require("./severity");
var _risk_score = require("./risk_score");
var _translations2 = require("./translations");
var _helpers = require("../../../timelines/components/side_panel/event_details/helpers");
var _context = require("../context");
var _formatted_date = require("../../../common/components/formatted_date");
var _test_ids = require("./test_ids");
var _share_button = require("./share_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Document details flyout right section header
 */
const HeaderTitle = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    dataFormattedForFieldBrowser
  } = (0, _context.useRightPanelContext)();
  const {
    isAlert,
    ruleName,
    timestamp,
    alertUrl
  } = (0, _helpers.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const {
    showAssistant,
    promptContextId
  } = (0, _use_assistant.useAssistant)({
    dataFormattedForFieldBrowser,
    isAlert
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("h4", {
    "data-test-subj": _test_ids.FLYOUT_HEADER_TITLE_TEST_ID
  }, isAlert && !(0, _lodash.isEmpty)(ruleName) ? ruleName : _translations2.DOCUMENT_DETAILS)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, isAlert && alertUrl && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_share_button.ShareButton, {
    alertUrl: alertUrl
  })), showAssistant && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_elasticAssistant.NewChatById, {
    conversationId: isAlert ? _translations.ALERT_SUMMARY_CONVERSATION_ID : _translations.EVENT_SUMMARY_CONVERSATION_ID,
    promptContextId: promptContextId
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), timestamp && /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
    value: new Date(timestamp)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_severity.DocumentSeverity, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_risk_score.RiskScore, null))));
});
exports.HeaderTitle = HeaderTitle;
HeaderTitle.displayName = 'HeaderTitle';