"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PanelHeaderRightSectionWrapper = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin-right: ${({
  theme
}) => theme.eui.euiSizeM};
`;
const IconWrapper = (0, _styledComponents.default)(_eui.EuiIcon)`
  margin: ${({
  theme
}) => theme.eui.euiSizeS} 0;
`;
/**
 * Panel component to display user or host information.
 */
const EntityPanel = ({
  title,
  iconType,
  children,
  expandable = false,
  expanded = false,
  headerContent,
  'data-test-subj': dataTestSub
}) => {
  const [toggleStatus, setToggleStatus] = (0, _react.useState)(expanded);
  const toggleQuery = (0, _react.useCallback)(() => {
    setToggleStatus(!toggleStatus);
  }, [setToggleStatus, toggleStatus]);
  const toggleIcon = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": _test_ids.ENTITY_PANEL_TOGGLE_BUTTON_TEST_ID,
    "aria-label": `entity-toggle`,
    color: "text",
    display: "empty",
    iconType: toggleStatus ? 'arrowDown' : 'arrowRight',
    onClick: toggleQuery,
    size: "s"
  }), [toggleStatus, toggleQuery]);
  const headerLeftSection = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    "data-test-subj": _test_ids.ENTITY_PANEL_HEADER_LEFT_SECTION_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, expandable && children && toggleIcon), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(IconWrapper, {
    type: iconType
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, title))))), [title, children, toggleIcon, expandable, iconType]);
  const headerRightSection = (0, _react.useMemo)(() => headerContent && /*#__PURE__*/_react.default.createElement(PanelHeaderRightSectionWrapper, {
    grow: false,
    "data-test-subj": _test_ids.ENTITY_PANEL_HEADER_RIGHT_SECTION_TEST_ID
  }, headerContent), [headerContent]);
  const showContent = (0, _react.useMemo)(() => {
    if (!children) {
      return false;
    }
    return !expandable || expandable && toggleStatus;
  }, [children, expandable, toggleStatus]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    grow: true,
    hasBorder: true,
    "data-test-subj": dataTestSub
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    color: "subdued",
    paddingSize: 'xs',
    "data-test-subj": _test_ids.ENTITY_PANEL_HEADER_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, headerLeftSection, headerRightSection)), showContent && /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": _test_ids.ENTITY_PANEL_CONTENT_TEST_ID
  }, children)));
};
exports.EntityPanel = EntityPanel;
EntityPanel.displayName = 'EntityPanel';