"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Description = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _context = require("../context");
var _helpers = require("../../../timelines/components/side_panel/event_details/helpers");
var _test_ids = require("./test_ids");
var _translations = require("./translations");
var _formatted_field_helpers = require("../../../timelines/components/timeline/body/renderers/formatted_field_helpers");
var _constants = require("../../../timelines/components/timeline/body/renderers/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiIcon = (0, _styledComponents.default)(_eui.EuiIcon)`
  margin-left: ${({
  theme
}) => theme.eui.euiSizeXS};
`;
/**
 * Displays the description of a document.
 * If the document is an alert we show the rule description. If the document is of another type, we show -.
 * By default, the text is truncated to only shows 2 lines.
 * The Expand/Collapse button allows the user to see the whole description.
 */
const Description = ({
  expanded = false
}) => {
  const [isExpanded, setIsExpanded] = (0, _react.useState)(expanded);
  const {
    dataFormattedForFieldBrowser,
    scopeId,
    eventId
  } = (0, _context.useRightPanelContext)();
  const {
    isAlert,
    ruleDescription,
    ruleId,
    ruleName
  } = (0, _helpers.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const viewRule = (0, _react.useMemo)(() => !(0, _lodash.isEmpty)(ruleName) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_formatted_field_helpers.RenderRuleName, {
    contextId: scopeId,
    eventId: eventId,
    fieldName: _constants.SIGNAL_RULE_NAME_FIELD_NAME,
    fieldType: 'string',
    isAggregatable: false,
    isDraggable: false,
    linkValue: ruleId,
    value: _translations.VIEW_RULE_TEXT
  }, _translations.VIEW_RULE_TEXT, /*#__PURE__*/_react.default.createElement(StyledEuiIcon, {
    type: "popout",
    size: "m"
  }))), [ruleName, ruleId, scopeId, eventId]);
  if (!dataFormattedForFieldBrowser) {
    return null;
  }
  const hasRuleDescription = ruleDescription && ruleDescription.length > 0;

  // TODO look into hiding the expand/collapse button if the description is short
  //  see https://github.com/elastic/security-team/issues/6248

  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.DESCRIPTION_TITLE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, isAlert ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("h5", null, _translations.RULE_DESCRIPTION_TITLE)), viewRule) : /*#__PURE__*/_react.default.createElement("h5", null, _translations.DOCUMENT_DESCRIPTION_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.DESCRIPTION_DETAILS_TEST_ID,
    css: (0, _react2.css)`
              word-break: break-word;
              ${!isExpanded && `
              display: -webkit-box;
              -webkit-line-clamp: 2;
              -webkit-box-orient: vertical;
              overflow: hidden;
              `}
            `
  }, hasRuleDescription ? ruleDescription : '-'), hasRuleDescription ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    onClick: () => setIsExpanded(preIsExpanded => !preIsExpanded),
    "data-test-subj": _test_ids.DESCRIPTION_EXPAND_BUTTON_TEST_ID
  }, isExpanded ? _translations.DOCUMENT_DESCRIPTION_COLLAPSE_BUTTON : _translations.DOCUMENT_DESCRIPTION_EXPAND_BUTTON)) : null)));
};
exports.Description = Description;
Description.displayName = 'Description';