"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizeTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _test_ids = require("./test_ids");
var _analyze_graph = require("../components/analyze_graph");
var _translations = require("./translations");
var _session_view = require("../components/session_view");
var _user_actions = require("../../../common/lib/apm/user_actions");
var _use_start_transaction = require("../../../common/lib/apm/use_start_transaction");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const visualizeButtons = [{
  id: _session_view.SESSION_VIEW_ID,
  label: _translations.SESSION_VIEW_BUTTON,
  'data-test-subj': _test_ids.VISUALIZE_TAB_SESSION_VIEW_BUTTON_TEST_ID
}, {
  id: _analyze_graph.ANALYZE_GRAPH_ID,
  label: _translations.ANALYZER_GRAPH_BUTTON,
  'data-test-subj': _test_ids.VISUALIZE_TAB_GRAPH_ANALYZER_BUTTON_TEST_ID
}];

/**
 * Visualize view displayed in the document details expandable flyout left section
 */
const VisualizeTab = /*#__PURE__*/(0, _react.memo)(() => {
  const [activeVisualizationId, setActiveVisualizationId] = (0, _react.useState)(_session_view.SESSION_VIEW_ID);
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const onChangeCompressed = (0, _react.useCallback)(optionId => {
    setActiveVisualizationId(optionId);
    if (optionId === _analyze_graph.ANALYZE_GRAPH_ID) {
      startTransaction({
        name: _user_actions.ALERTS_ACTIONS.OPEN_ANALYZER
      });
    }
  }, [startTransaction]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    color: "primary",
    name: "coarsness",
    legend: _translations.VISUALIZE_BUTTONGROUP_OPTIONS,
    options: visualizeButtons,
    idSelected: activeVisualizationId,
    onChange: id => onChangeCompressed(id),
    buttonSize: "compressed",
    isFullWidth: true,
    "data-test-subj": _test_ids.VISUALIZE_TAB_BUTTON_GROUP_TEST_ID
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), activeVisualizationId === _session_view.SESSION_VIEW_ID && /*#__PURE__*/_react.default.createElement(_session_view.SessionView, null), activeVisualizationId === _analyze_graph.ANALYZE_GRAPH_ID && /*#__PURE__*/_react.default.createElement(_analyze_graph.AnalyzeGraph, null));
});
exports.VisualizeTab = VisualizeTab;
VisualizeTab.displayName = 'VisualizeTab';