"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tabs = void 0;
var _react = _interopRequireDefault(require("react"));
var _visualize_tab = require("./tabs/visualize_tab");
var _investigation_tab = require("./tabs/investigation_tab");
var _translations = require("./translations");
var _insights_tab = require("./tabs/insights_tab");
var _test_ids = require("./test_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tabs = [{
  id: 'visualize',
  'data-test-subj': _test_ids.VISUALIZE_TAB_TEST_ID,
  name: _translations.VISUALIZE_TAB,
  content: /*#__PURE__*/_react.default.createElement(_visualize_tab.VisualizeTab, null)
}, {
  id: 'insights',
  'data-test-subj': _test_ids.INSIGHTS_TAB_TEST_ID,
  name: _translations.INSIGHTS_TAB,
  content: /*#__PURE__*/_react.default.createElement(_insights_tab.InsightsTab, null)
}, {
  id: 'investigation',
  'data-test-subj': _test_ids.INVESTIGATION_TAB_TEST_ID,
  name: _translations.INVESTIGATIONS_TAB,
  content: /*#__PURE__*/_react.default.createElement(_investigation_tab.InvestigationTab, null)
}];
exports.tabs = tabs;