"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _entity_panel = require("../../right/components/entity_panel");
var _user_overview = require("../../../overview/components/user_overview");
var _anomaly_table_provider = require("../../../common/components/ml/anomaly/anomaly_table_provider");
var _inspect = require("../../../common/components/inspect");
var _links = require("../../../common/components/links");
var _search_strategy = require("../../../../common/search_strategy");
var _common = require("../../../explore/components/risk_score/severity/common");
var _field_renderers = require("../../../timelines/components/field_renderers/field_renderers");
var _cell_actions = require("../../../common/components/cell_actions");
var _constants = require("../../../common/store/inputs/constants");
var _use_global_time = require("../../../common/containers/use_global_time");
var _sourcerer = require("../../../common/containers/sourcerer");
var _score_interval_to_datetime = require("../../../common/components/ml/score/score_interval_to_datetime");
var _actions = require("../../../common/store/inputs/actions");
var _host_to_criteria = require("../../../common/components/ml/criteria/host_to_criteria");
var _manage_query = require("../../../common/components/page/manage_query");
var _observed_details = require("../../../explore/users/containers/users/observed_details");
var _related_hosts = require("../../../common/containers/related_entities/related_hosts");
var _use_ml_capabilities = require("../../../common/components/ml/hooks/use_ml_capabilities");
var _empty_value = require("../../../common/components/empty_value");
var _test_ids = require("./test_ids");
var _translations = require("../../../explore/components/risk_score/translations");
var _translations2 = require("../../../explore/hosts/components/hosts_table/translations");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const USER_DETAILS_ID = 'entities-users-details';
const RELATED_HOSTS_ID = 'entities-users-related-hosts';
const UserOverviewManage = (0, _manage_query.manageQuery)(_user_overview.UserOverview);
const RelatedHostsManage = (0, _manage_query.manageQuery)(_inspect.InspectButtonContainer);
/**
 * User details and related users, displayed in the document details expandable flyout left section under the Insights tab, Entities tab
 */
const UserDetails = ({
  userName,
  timestamp
}) => {
  const {
    to,
    from,
    deleteQuery,
    setQuery,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  const {
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)();
  const dispatch = (0, _reactRedux.useDispatch)();
  // create a unique, but stable (across re-renders) query id
  const userDetailsQueryId = (0, _react.useMemo)(() => `${USER_DETAILS_ID}-${(0, _uuid.v4)()}`, []);
  const relatedHostsQueryId = (0, _react.useMemo)(() => `${RELATED_HOSTS_ID}-${(0, _uuid.v4)()}`, []);
  const isPlatinumOrTrialLicense = (0, _use_ml_capabilities.useMlCapabilities)().isPlatinumOrTrialLicense;
  const narrowDateRange = (0, _react.useCallback)((score, interval) => {
    const fromTo = (0, _score_interval_to_datetime.scoreIntervalToDateTime)(score, interval);
    dispatch((0, _actions.setAbsoluteRangeDatePicker)({
      id: _constants.InputsModelId.global,
      from: fromTo.from,
      to: fromTo.to
    }));
  }, [dispatch]);
  const [isUserLoading, {
    inspect,
    userDetails,
    refetch
  }] = (0, _observed_details.useObservedUserDetails)({
    id: userDetailsQueryId,
    startDate: from,
    endDate: to,
    userName,
    indexNames: selectedPatterns,
    skip: selectedPatterns.length === 0
  });
  const {
    loading: isRelatedHostLoading,
    inspect: inspectRelatedHosts,
    relatedHosts,
    totalCount,
    refetch: refetchRelatedHosts
  } = (0, _related_hosts.useUserRelatedHosts)({
    userName,
    indexNames: selectedPatterns,
    from: timestamp,
    // related hosts are hosts this user has successfully authenticated onto AFTER alert time
    skip: selectedPatterns.length === 0
  });
  const relatedHostsColumns = (0, _react.useMemo)(() => [{
    field: 'host',
    name: i18n.RELATED_ENTITIES_NAME_COLUMN_TITLE,
    render: host => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      grow: false,
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
      mode: _cell_actions.CellActionsMode.HOVER_RIGHT,
      visibleCellActions: 5,
      showActionTooltips: true,
      triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
      field: {
        name: 'host.name',
        value: host,
        type: 'keyword'
      }
    }, host))
  }, {
    field: 'ip',
    name: i18n.RELATED_ENTITIES_IP_COLUMN_TITLE,
    render: ips => {
      return /*#__PURE__*/_react.default.createElement(_field_renderers.DefaultFieldRenderer, {
        rowItems: ips,
        attrName: 'host.ip',
        idPrefix: '',
        isDraggable: false,
        render: ip => ip != null ? /*#__PURE__*/_react.default.createElement(_links.NetworkDetailsLink, {
          ip: ip
        }) : (0, _empty_value.getEmptyTagValue)()
      });
    }
  }, ...(isPlatinumOrTrialLicense ? [{
    field: 'risk',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _translations2.HOST_RISK_TOOLTIP
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _translations.ENTITY_RISK_CLASSIFICATION)(_search_strategy.RiskScoreEntity.host), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "subdued",
      type: "iInCircle",
      className: "eui-alignTop"
    }))),
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: false,
    render: riskScore => {
      if (riskScore != null) {
        return /*#__PURE__*/_react.default.createElement(_common.RiskScore, {
          severity: riskScore
        });
      }
      return (0, _empty_value.getEmptyTagValue)();
    }
  }] : [])], [isPlatinumOrTrialLicense]);
  const relatedHostsCount = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "storage"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, `${i18n.RELATED_HOSTS_TITLE}: ${totalCount}`)))), [totalCount]);
  const pagination = {
    pageSize: 4,
    showPerPageOptions: false
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, i18n.USERS_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_entity_panel.EntityPanel, {
    title: userName,
    iconType: 'user',
    expandable: true,
    expanded: true,
    headerContent: relatedHostsCount,
    "data-test-subj": _test_ids.USER_DETAILS_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, i18n.USERS_INFO_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_anomaly_table_provider.AnomalyTableProvider, {
    criteriaFields: (0, _host_to_criteria.hostToCriteria)(userDetails),
    startDate: from,
    endDate: to,
    skip: isInitializing
  }, ({
    isLoadingAnomaliesData,
    anomaliesData,
    jobNameById
  }) => /*#__PURE__*/_react.default.createElement(UserOverviewManage, {
    id: userDetailsQueryId,
    isInDetailsSidePanel: false,
    data: userDetails,
    anomaliesData: anomaliesData,
    isLoadingAnomaliesData: isLoadingAnomaliesData,
    loading: isUserLoading,
    startDate: from,
    endDate: to,
    narrowDateRange: narrowDateRange,
    setQuery: setQuery,
    refetch: refetch,
    inspect: inspect,
    userName: userName,
    indexPatterns: selectedPatterns,
    jobNameById: jobNameById
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, i18n.RELATED_HOSTS_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.RELATED_HOSTS_TOOL_TIP
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "subdued",
    type: "iInCircle",
    className: "eui-alignTop"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(RelatedHostsManage, {
    id: relatedHostsQueryId,
    inspect: inspectRelatedHosts,
    loading: isRelatedHostLoading,
    setQuery: setQuery,
    deleteQuery: deleteQuery,
    refetch: refetchRelatedHosts
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    columns: relatedHostsColumns,
    items: relatedHosts,
    loading: isRelatedHostLoading,
    "data-test-subj": _test_ids.USER_DETAILS_RELATED_HOSTS_TABLE_TEST_ID,
    pagination: pagination
  }), /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    queryId: relatedHostsQueryId,
    title: i18n.RELATED_HOSTS_TITLE,
    inspectIndex: 0
  }))));
};
exports.UserDetails = UserDetails;
UserDetails.displayName = 'UserDetails';