"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrevalenceDetailsPrevalenceCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _test_ids = require("./test_ids");
var _use_fetch_field_value_pair_with_aggregation = require("../../shared/hooks/use_fetch_field_value_pair_with_aggregation");
var _types = require("../../../../common/types");
var _use_fetch_unique_by_field = require("../../shared/hooks/use_fetch_unique_by_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Component displaying a value in many PrevalenceDetails table cells. It is used for the fifth and sixth columns,
 * which displays the prevalence percentage for host.name and user.name fields.
 */
const PrevalenceDetailsPrevalenceCell = ({
  highlightedField,
  scopeId,
  aggregationField
}) => {
  const {
    loading: aggregationLoading,
    error: aggregationError,
    count: aggregationCount
  } = (0, _use_fetch_field_value_pair_with_aggregation.useFetchFieldValuePairWithAggregation)({
    highlightedField,
    isActiveTimelines: scopeId === _types.TimelineId.active,
    aggregationField
  });
  const {
    loading: uniqueLoading,
    error: uniqueError,
    count: uniqueCount
  } = (0, _use_fetch_unique_by_field.useFetchUniqueByField)({
    field: aggregationField
  });
  if (aggregationLoading || uniqueLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": _test_ids.PREVALENCE_DETAILS_PREVALENCE_CELL_LOADING_TEST_ID
    });
  }
  const prevalence = aggregationCount / uniqueCount;
  if (aggregationError || uniqueError || !isFinite(prevalence)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "data-test-subj": _test_ids.PREVALENCE_DETAILS_PREVALENCE_CELL_ERROR_TEST_ID,
      type: "error",
      color: "danger"
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.PREVALENCE_DETAILS_PREVALENCE_CELL_VALUE_TEST_ID
  }, Math.round(prevalence * 100), '%');
};
exports.PrevalenceDetailsPrevalenceCell = PrevalenceDetailsPrevalenceCell;
PrevalenceDetailsPrevalenceCell.displayName = 'PrevalenceDetailsPrevalenceCell';