"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntitiesDetails = exports.ENTITIES_TAB_ID = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _context = require("../context");
var _utils = require("../../shared/utils");
var _user_details = require("./user_details");
var _host_details = require("./host_details");
var _test_ids = require("./test_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENTITIES_TAB_ID = 'entities-details';

/**
 * Entities displayed in the document details expandable flyout left section under the Insights tab
 */
exports.ENTITIES_TAB_ID = ENTITIES_TAB_ID;
const EntitiesDetails = () => {
  const {
    getFieldsData
  } = (0, _context.useLeftPanelContext)();
  const hostName = (0, _utils.getField)(getFieldsData('host.name'));
  const userName = (0, _utils.getField)(getFieldsData('user.name'));
  const timestamp = (0, _utils.getField)(getFieldsData('@timestamp'));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "data-test-subj": _test_ids.ENTITIES_DETAILS_TEST_ID
  }, userName && timestamp && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_user_details.UserDetails, {
    userName: userName,
    timestamp: timestamp
  })), hostName && timestamp && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_host_details.HostDetails, {
    hostName: hostName,
    timestamp: timestamp
  })));
};
exports.EntitiesDetails = EntitiesDetails;
EntitiesDetails.displayName = 'EntitiesDetails';