"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CorrelationsDetails = exports.CORRELATIONS_TAB_ID = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _details = require("../../../timelines/containers/details");
var _sourcerer = require("../../../common/containers/sourcerer");
var _use_correlations = require("../../shared/hooks/use_correlations");
var _context = require("../context");
var _use_route_spy = require("../../../common/utils/route/use_route_spy");
var _common = require("../../../../common");
var _model = require("../../../common/store/sourcerer/model");
var _entity_panel = require("../../right/components/entity_panel");
var _correlations_details_alerts_table = require("./correlations_details_alerts_table");
var _translations = require("../../shared/translations");
var _test_ids = require("./test_ids");
var _correlations_cases_table = require("./correlations_cases_table");
var _translations2 = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CORRELATIONS_TAB_ID = 'correlations-details';

/**
 * Correlations displayed in the document details expandable flyout left section under the Insights tab
 */
exports.CORRELATIONS_TAB_ID = CORRELATIONS_TAB_ID;
const CorrelationsDetails = () => {
  const {
    indexName,
    eventId,
    scopeId
  } = (0, _context.useLeftPanelContext)();
  const [{
    pageName
  }] = (0, _use_route_spy.useRouteSpy)();
  const sourcererScope = pageName === _common.SecurityPageName.detections ? _model.SourcererScopeName.detections : _model.SourcererScopeName.default;
  const sourcererDataView = (0, _sourcerer.useSourcererDataView)(sourcererScope);
  const [isEventDataLoading, eventData, _searchHit, dataAsNestedObject] = (0, _details.useTimelineEventsDetails)({
    indexName,
    eventId,
    runtimeMappings: sourcererDataView.runtimeMappings,
    skip: !eventId
  });
  const {
    loading: isCorrelationsLoading,
    error: correlationsError,
    ancestryAlertsIds,
    alertsBySessionIds,
    sameSourceAlertsIds,
    cases
  } = (0, _use_correlations.useCorrelations)({
    eventId,
    dataAsNestedObject,
    dataFormattedForFieldBrowser: eventData,
    scopeId
  });
  const topLevelLoading = isEventDataLoading || isCorrelationsLoading;
  if (topLevelLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceAround"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    })));
  }
  if (correlationsError) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "error",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, (0, _translations.ERROR_TITLE)('Correlation Details')),
      body: /*#__PURE__*/_react.default.createElement("p", null, (0, _translations.ERROR_MESSAGE)('Correlation Details view')),
      "data-test-subj": _test_ids.CORRELATIONS_DETAILS_ERROR_TEST_ID
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_entity_panel.EntityPanel, {
    title: (0, _translations2.ANCESTRY_ALERTS_HEADING)(ancestryAlertsIds.length),
    iconType: 'warning',
    expandable: true,
    "data-test-subj": _test_ids.CORRELATIONS_DETAILS_BY_ANCESTRY_SECTION_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_correlations_details_alerts_table.AlertsTable, {
    alertIds: ancestryAlertsIds,
    "data-test-subj": _test_ids.CORRELATIONS_DETAILS_BY_ANCESTRY_TABLE_TEST_ID
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_entity_panel.EntityPanel, {
    title: (0, _translations2.SOURCE_ALERTS_HEADING)(sameSourceAlertsIds.length),
    iconType: 'warning',
    expandable: true,
    "data-test-subj": _test_ids.CORRELATIONS_DETAILS_BY_SOURCE_SECTION_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_correlations_details_alerts_table.AlertsTable, {
    alertIds: sameSourceAlertsIds,
    "data-test-subj": _test_ids.CORRELATIONS_DETAILS_BY_SOURCE_TABLE_TEST_ID
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_entity_panel.EntityPanel, {
    title: (0, _translations2.SESSION_ALERTS_HEADING)(alertsBySessionIds.length),
    iconType: 'warning',
    expandable: true,
    "data-test-subj": _test_ids.CORRELATIONS_DETAILS_BY_SESSION_SECTION_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_correlations_details_alerts_table.AlertsTable, {
    alertIds: alertsBySessionIds,
    "data-test-subj": _test_ids.CORRELATIONS_DETAILS_BY_SESSION_TABLE_TEST_ID
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_entity_panel.EntityPanel, {
    title: (0, _translations2.RELATED_CASES_HEADING)(cases.length),
    iconType: 'warning',
    expandable: true,
    "data-test-subj": _test_ids.CORRELATIONS_DETAILS_CASES_SECTION_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_correlations_cases_table.CorrelationsCasesTable, {
    cases: cases
  })));
};
exports.CorrelationsDetails = CorrelationsDetails;
CorrelationsDetails.displayName = 'CorrelationsDetails';