"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usersAnomaliesJobIdFilterSelector = exports.usersAnomaliesIntervalSelector = exports.userRiskScoreSeverityFilterSelector = exports.userRiskScoreSelector = exports.authenticationsSelector = exports.allUsersSelector = void 0;
var _reselect = require("reselect");
var _model = require("./model");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const selectUserPage = state => state.users.page;
const selectUsers = (state, usersType) => state.users[usersType];
const allUsersSelector = () => (0, _reselect.createSelector)(selectUserPage, users => users.queries[_model.UsersTableType.allUsers]);
exports.allUsersSelector = allUsersSelector;
const userRiskScoreSelector = () => (0, _reselect.createSelector)(selectUserPage, users => users.queries[_model.UsersTableType.risk]);
exports.userRiskScoreSelector = userRiskScoreSelector;
const userRiskScoreSeverityFilterSelector = () => (0, _reselect.createSelector)(selectUserPage, users => users.queries[_model.UsersTableType.risk].severitySelection);
exports.userRiskScoreSeverityFilterSelector = userRiskScoreSeverityFilterSelector;
const authenticationsSelector = () => (0, _reselect.createSelector)(selectUserPage, users => users.queries[_model.UsersTableType.authentications]);
exports.authenticationsSelector = authenticationsSelector;
const usersAnomaliesJobIdFilterSelector = () => (0, _reselect.createSelector)(selectUsers, users => users.queries[_model.UsersTableType.anomalies].jobIdSelection);
exports.usersAnomaliesJobIdFilterSelector = usersAnomaliesJobIdFilterSelector;
const usersAnomaliesIntervalSelector = () => (0, _reselect.createSelector)(selectUsers, users => users.queries[_model.UsersTableType.anomalies].intervalSelection);
exports.usersAnomaliesIntervalSelector = usersAnomaliesIntervalSelector;