"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUserRiskScoreColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _cell_actions = require("../../../../common/components/cell_actions");
var _helpers = require("../../../../common/components/drag_and_drop/helpers");
var _empty_value = require("../../../../common/components/empty_value");
var i18n = _interopRequireWildcard(require("./translations"));
var _common = require("../../../components/risk_score/severity/common");
var _search_strategy = require("../../../../../common/search_strategy");
var _links = require("../../../../common/components/links");
var _model = require("../../store/model");
var _translations2 = require("../../../components/risk_score/translations");
var _constants = require("../../../components/risk_score/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUserRiskScoreColumns = ({
  dispatchSeverityUpdate
}) => [{
  field: 'user.name',
  name: i18n.USER_NAME,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  render: userName => {
    if (userName != null && userName.length > 0) {
      const id = (0, _helpers.escapeDataProviderId)(`user-risk-score-table-userName-${userName}`);
      return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
        key: id,
        mode: _cell_actions.CellActionsMode.HOVER_DOWN,
        visibleCellActions: 5,
        showActionTooltips: true,
        triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
        field: {
          name: 'user.name',
          value: userName,
          type: 'keyword',
          aggregatable: true
        },
        metadata: {
          telemetry: _constants.CELL_ACTIONS_TELEMETRY
        }
      }, /*#__PURE__*/_react.default.createElement(_links.UserDetailsLink, {
        userName: userName,
        userTab: _model.UsersTableType.risk
      }));
    }
    return (0, _empty_value.getEmptyTagValue)();
  }
}, {
  field: _search_strategy.RiskScoreFields.userRiskScore,
  name: i18n.USER_RISK_SCORE,
  truncateText: true,
  mobileOptions: {
    show: true
  },
  sortable: true,
  render: riskScore => {
    if (riskScore != null) {
      return /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "risk-score-truncate",
        title: `${riskScore}`
      }, Math.round(riskScore));
    }
    return (0, _empty_value.getEmptyTagValue)();
  }
}, {
  field: _search_strategy.RiskScoreFields.userRisk,
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.USER_RISK_TOOLTIP
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _translations2.ENTITY_RISK_CLASSIFICATION)(_search_strategy.RiskScoreEntity.user), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "subdued",
    type: "iInCircle",
    className: "eui-alignTop"
  }))),
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  render: risk => {
    if (risk != null) {
      return /*#__PURE__*/_react.default.createElement(_common.RiskScore, {
        toolTipContent: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => dispatchSeverityUpdate(risk)
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs"
        }, i18n.VIEW_USERS_BY_SEVERITY(risk.toLowerCase()))),
        severity: risk
      });
    }
    return (0, _empty_value.getEmptyTagValue)();
  }
}];
exports.getUserRiskScoreColumns = getUserRiskScoreColumns;