"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_RISK_TOOLTIP = exports.USER_RISK = exports.USER_NAME = exports.USERS = exports.UNIT = exports.ROWS_5 = exports.ROWS_10 = exports.LAST_SEEN = exports.DOMAIN = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const USERS = _i18n.i18n.translate('xpack.securitySolution.usersTable.title', {
  defaultMessage: 'Users'
});
exports.USERS = USERS;
const USER_NAME = _i18n.i18n.translate('xpack.securitySolution.usersTable.userNameTitle', {
  defaultMessage: 'User name'
});
exports.USER_NAME = USER_NAME;
const LAST_SEEN = _i18n.i18n.translate('xpack.securitySolution.usersTable.lastSeenTitle', {
  defaultMessage: 'Last seen'
});
exports.LAST_SEEN = LAST_SEEN;
const DOMAIN = _i18n.i18n.translate('xpack.securitySolution.usersTable.domainTitle', {
  defaultMessage: 'Domain'
});
exports.DOMAIN = DOMAIN;
const ROWS_5 = _i18n.i18n.translate('xpack.securitySolution.usersTable.rows', {
  values: {
    numRows: 5
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
exports.ROWS_5 = ROWS_5;
const ROWS_10 = _i18n.i18n.translate('xpack.securitySolution.usersTable.rows', {
  values: {
    numRows: 10
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
exports.ROWS_10 = ROWS_10;
const UNIT = totalCount => _i18n.i18n.translate('xpack.securitySolution.usersTable.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {user} other {users}}`
});
exports.UNIT = UNIT;
const USER_RISK_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.usersTable.userRiskToolTip', {
  defaultMessage: 'User risk classification is determined by user risk score. Users classified as Critical or High are indicated as risky.'
});
exports.USER_RISK_TOOLTIP = USER_RISK_TOOLTIP;
const USER_RISK = _i18n.i18n.translate('xpack.securitySolution.usersTable.riskTitle', {
  defaultMessage: 'User risk classification'
});
exports.USER_RISK = USER_RISK;