"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TlsQueryTabBody = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _manage_query = require("../../../../common/components/page/manage_query");
var _tls = require("../../containers/tls");
var _tls_table = require("../../components/tls_table");
var _query_toggle = require("../../../../common/containers/query_toggle");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TlsTableManage = (0, _manage_query.manageQuery)(_tls_table.TlsTable);
const TlsQueryTabBodyComponent = ({
  endDate,
  filterQuery,
  flowTarget,
  indexNames,
  ip = '',
  setQuery,
  skip,
  startDate,
  type
}) => {
  const queryId = `${_tls.ID}-${type}`;
  const {
    toggleStatus
  } = (0, _query_toggle.useQueryToggle)(queryId);
  const [querySkip, setQuerySkip] = (0, _react.useState)(skip || !toggleStatus);
  (0, _react.useEffect)(() => {
    setQuerySkip(skip || !toggleStatus);
  }, [skip, toggleStatus]);
  const [loading, {
    id,
    inspect,
    isInspected,
    tls,
    totalCount,
    pageInfo,
    loadPage,
    refetch
  }] = (0, _tls.useNetworkTls)({
    endDate,
    filterQuery,
    flowTarget,
    id: queryId,
    indexNames,
    ip,
    skip: querySkip,
    startDate,
    type
  });
  return /*#__PURE__*/_react.default.createElement(TlsTableManage, {
    data: tls,
    id: id,
    inspect: inspect,
    isInspect: isInspected,
    fakeTotalCount: (0, _fp.getOr)(50, 'fakeTotalCount', pageInfo),
    loading: loading,
    loadPage: loadPage,
    showMorePagesIndicator: (0, _fp.getOr)(false, 'showMorePagesIndicator', pageInfo),
    refetch: refetch,
    setQuery: setQuery,
    setQuerySkip: setQuerySkip,
    totalCount: totalCount,
    type: type
  });
};
TlsQueryTabBodyComponent.displayName = 'TlsQueryTabBodyComponent';
const TlsQueryTabBody = /*#__PURE__*/_react.default.memo(TlsQueryTabBodyComponent);
exports.TlsQueryTabBody = TlsQueryTabBody;