"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _use_ml_capabilities = require("../../../common/components/ml/hooks/use_ml_capabilities");
var _has_ml_user_permissions = require("../../../../common/machine_learning/has_ml_user_permissions");
var _details = require("./details");
var _network = require("./network");
var _navigation = require("./navigation");
var _types = require("./navigation/types");
var _ml_network_conditional_container = require("../../../common/components/ml/conditional_links/ml_network_conditional_container");
var _constants = require("../../../../common/constants");
var _search_strategy = require("../../../../common/search_strategy");
var _constants2 = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPathWithFlowType = (detailName, flowTarget) => `${_constants.NETWORK_PATH}/ip/${detailName}/${flowTarget || _search_strategy.FlowTargetSourceDest.source}/${_types.NetworkRouteType.flows}`;
const NetworkContainerComponent = () => {
  const capabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const capabilitiesFetched = capabilities.capabilitiesFetched;
  const userHasMlUserPermissions = (0, _react.useMemo)(() => (0, _has_ml_user_permissions.hasMlUserPermissions)(capabilities), [capabilities]);
  const networkRoutePath = (0, _react.useMemo)(() => (0, _navigation.getNetworkRoutePath)(capabilitiesFetched, userHasMlUserPermissions), [capabilitiesFetched, userHasMlUserPermissions]);
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    strict: true,
    path: _constants.NETWORK_PATH,
    render: ({
      location: {
        search = ''
      }
    }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: {
        pathname: `${_constants.NETWORK_PATH}/${_types.NetworkRouteType.flows}`,
        search
      }
    })
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_PATH}/ml-network`
  }, /*#__PURE__*/_react.default.createElement(_ml_network_conditional_container.MlNetworkConditionalContainer, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    strict: true,
    path: networkRoutePath
  }, /*#__PURE__*/_react.default.createElement(_network.Network, {
    capabilitiesFetched: capabilities.capabilitiesFetched,
    hasMlUserPermissions: userHasMlUserPermissions
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.NETWORK_DETAILS_TAB_PATH
  }, /*#__PURE__*/_react.default.createElement(_details.NetworkDetails, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants2.NETWORK_DETAILS_PAGE_PATH}/:flowTarget(${_constants2.FLOW_TARGET_PARAM})?`,
    render: ({
      match: {
        params: {
          detailName,
          flowTarget
        }
      },
      location: {
        search = ''
      }
    }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: {
        pathname: getPathWithFlowType(detailName, flowTarget),
        search
      }
    })
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: _constants.NETWORK_PATH
    }
  })));
};
const NetworkContainer = /*#__PURE__*/_react.default.memo(NetworkContainerComponent);
exports.NetworkContainer = NetworkContainer;