"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usersTableId = exports.UsersTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _use_selector = require("../../../../common/hooks/use_selector");
var _utility_types = require("../../../../../common/utility_types");
var _store = require("../../store");
var _search_strategy = require("../../../../../common/search_strategy");
var _paginated_table = require("../../../components/paginated_table");
var _columns = require("./columns");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tableType = _store.networkModel.NetworkDetailsTableType.users;
const rowItems = [{
  text: i18n.ROWS_5,
  numberOfRow: 5
}, {
  text: i18n.ROWS_10,
  numberOfRow: 10
}];
const usersTableId = 'users-table';
exports.usersTableId = usersTableId;
const UsersTableComponent = ({
  data,
  fakeTotalCount,
  flowTarget,
  id,
  isInspect,
  loading,
  loadPage,
  setQuerySkip,
  showMorePagesIndicator,
  totalCount,
  type
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getUsersSelector = (0, _react.useMemo)(() => _store.networkSelectors.usersSelector(), []);
  const {
    activePage,
    sort,
    limit
  } = (0, _use_selector.useDeepEqualSelector)(getUsersSelector);
  const updateLimitPagination = (0, _react.useCallback)(newLimit => dispatch(_store.networkActions.updateNetworkTable({
    networkType: type,
    tableType,
    updates: {
      limit: newLimit
    }
  })), [dispatch, type]);
  const updateActivePage = (0, _react.useCallback)(newPage => dispatch(_store.networkActions.updateNetworkTable({
    networkType: type,
    tableType,
    updates: {
      activePage: newPage
    }
  })), [dispatch, type]);
  const onChange = (0, _react.useCallback)(criteria => {
    if (criteria.sort != null) {
      const splitField = criteria.sort.field.split('.');
      const newUsersSort = {
        field: getSortFromString(splitField[splitField.length - 1]),
        direction: criteria.sort.direction
      };
      if (!(0, _fastDeepEqual.default)(newUsersSort, sort)) {
        dispatch(_store.networkActions.updateNetworkTable({
          networkType: type,
          tableType,
          updates: {
            sort: newUsersSort
          }
        }));
      }
    }
  }, [dispatch, sort, type]);
  const columns = (0, _react.useMemo)(() => (0, _columns.getUsersColumns)(flowTarget, usersTableId),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [flowTarget, usersTableId]);
  return /*#__PURE__*/_react.default.createElement(_paginated_table.PaginatedTable, {
    activePage: activePage,
    columns: columns,
    dataTestSubj: `table-${tableType}`,
    showMorePagesIndicator: showMorePagesIndicator,
    headerCount: totalCount,
    headerTitle: i18n.USERS,
    headerUnit: i18n.UNIT(totalCount),
    id: id,
    isInspect: isInspect,
    itemsPerRow: rowItems,
    limit: limit,
    loading: loading,
    loadPage: loadPage,
    onChange: onChange,
    pageOfItems: data,
    setQuerySkip: setQuerySkip,
    sorting: getSortField(sort),
    totalCount: fakeTotalCount,
    updateActivePage: updateActivePage,
    updateLimitPagination: updateLimitPagination
  });
};
UsersTableComponent.displayName = 'UsersTableComponent';
const UsersTable = /*#__PURE__*/_react.default.memo(UsersTableComponent);
exports.UsersTable = UsersTable;
const getSortField = sortField => {
  switch (sortField.field) {
    case _search_strategy.NetworkUsersFields.name:
      return {
        field: `node.user.${sortField.field}`,
        direction: sortField.direction
      };
    case _search_strategy.NetworkUsersFields.count:
      return {
        field: `node.user.${sortField.field}`,
        direction: sortField.direction
      };
  }
  return (0, _utility_types.assertUnreachable)(sortField.field);
};
const getSortFromString = sortField => {
  switch (sortField) {
    case _search_strategy.NetworkUsersFields.name.valueOf():
      return _search_strategy.NetworkUsersFields.name;
    case _search_strategy.NetworkUsersFields.count.valueOf():
      return _search_strategy.NetworkUsersFields.count;
    default:
      return _search_strategy.NetworkUsersFields.name;
  }
};