"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTlsColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _helpers = require("../../../../common/components/tables/helpers");
var _localized_date_tooltip = require("../../../../common/components/localized_date_tooltip");
var _formatted_date = require("../../../../common/components/formatted_date");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTlsColumns = tableId => [{
  field: 'node',
  name: i18n.ISSUER,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: false,
  render: ({
    _id,
    issuers
  }) => (0, _helpers.getRowItemsWithActions)({
    values: issuers,
    fieldName: 'tls.server.issuer',
    fieldType: 'keyword',
    aggregatable: true,
    idPrefix: `${tableId}-${_id}-table-issuers`
  })
}, {
  field: 'node',
  name: i18n.SUBJECT,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: false,
  render: ({
    _id,
    subjects
  }) => (0, _helpers.getRowItemsWithActions)({
    values: subjects,
    fieldName: 'tls.server.subject',
    fieldType: 'keyword',
    aggregatable: true,
    idPrefix: `${tableId}-${_id}-table-subjects`
  })
}, {
  field: 'node._id',
  name: i18n.SHA1_FINGERPRINT,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  render: sha1 => (0, _helpers.getRowItemsWithActions)({
    values: sha1 ? [sha1] : undefined,
    fieldName: 'tls.server.hash.sha1',
    fieldType: 'keyword',
    aggregatable: true,
    idPrefix: `${tableId}-${sha1}-table-sha1`
  })
}, {
  field: 'node',
  name: i18n.JA3_FINGERPRINT,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: false,
  render: ({
    _id,
    ja3
  }) => (0, _helpers.getRowItemsWithActions)({
    values: ja3,
    fieldName: 'tls.server.ja3s',
    fieldType: 'keyword',
    aggregatable: true,
    idPrefix: `${tableId}-${_id}-table-ja3`
  })
}, {
  field: 'node',
  name: i18n.VALID_UNTIL,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: false,
  render: ({
    _id,
    notAfter
  }) => (0, _helpers.getRowItemsWithActions)({
    values: notAfter,
    fieldName: 'tls.server.not_after',
    fieldType: 'date',
    aggregatable: false,
    idPrefix: `${tableId}-${_id}-table-notAfter`,
    render: validUntil => /*#__PURE__*/_react.default.createElement(_localized_date_tooltip.LocalizedDateTooltip, {
      date: (0, _moment.default)(new Date(validUntil)).toDate()
    }, /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
      value: new Date(validUntil)
    }))
  })
}];
exports.getTlsColumns = getTlsColumns;