"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceDestinationWithArrows = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _source_destination_arrows = require("./source_destination_arrows");
var _source_destination_ip = require("./source_destination_ip");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Visualizes the communication between a source and a destination by
 * providing an interactive (draggable, hyperlinked) visualization,
 * which contains both the source and destination. (See
 * `SourceDestinationIp` ) for details on how the source and destination
 * are visually represented.
 */
const SourceDestinationWithArrows = /*#__PURE__*/_react.default.memo(({
  contextId,
  destinationBytes,
  destinationGeoContinentName,
  destinationGeoCountryName,
  destinationGeoCountryIsoCode,
  destinationGeoRegionName,
  destinationGeoCityName,
  destinationIp,
  destinationPackets,
  destinationPort,
  eventId,
  isDraggable,
  sourceBytes,
  sourceGeoContinentName,
  sourceGeoCountryName,
  sourceGeoCountryIsoCode,
  sourceGeoRegionName,
  sourceGeoCityName,
  sourcePackets,
  sourceIp,
  sourcePort
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "center",
  gutterSize: "none"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_source_destination_ip.SourceDestinationIp, {
  contextId: contextId,
  destinationGeoContinentName: destinationGeoContinentName,
  destinationGeoCountryName: destinationGeoCountryName,
  destinationGeoCountryIsoCode: destinationGeoCountryIsoCode,
  destinationGeoRegionName: destinationGeoRegionName,
  destinationGeoCityName: destinationGeoCityName,
  destinationIp: destinationIp,
  destinationPort: destinationPort,
  eventId: eventId,
  isDraggable: isDraggable,
  sourceGeoContinentName: sourceGeoContinentName,
  sourceGeoCountryName: sourceGeoCountryName,
  sourceGeoCountryIsoCode: sourceGeoCountryIsoCode,
  sourceGeoRegionName: sourceGeoRegionName,
  sourceGeoCityName: sourceGeoCityName,
  sourceIp: sourceIp,
  sourcePort: sourcePort,
  type: "source"
})), /*#__PURE__*/_react.default.createElement(_source_destination_arrows.SourceDestinationArrows, {
  contextId: contextId,
  destinationBytes: destinationBytes,
  destinationPackets: destinationPackets,
  eventId: eventId,
  isDraggable: isDraggable,
  sourceBytes: sourceBytes,
  sourcePackets: sourcePackets
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_source_destination_ip.SourceDestinationIp, {
  contextId: contextId,
  destinationGeoContinentName: destinationGeoContinentName,
  destinationGeoCountryName: destinationGeoCountryName,
  destinationGeoCountryIsoCode: destinationGeoCountryIsoCode,
  destinationGeoRegionName: destinationGeoRegionName,
  destinationGeoCityName: destinationGeoCityName,
  destinationIp: destinationIp,
  destinationPort: destinationPort,
  eventId: eventId,
  isDraggable: isDraggable,
  sourceGeoContinentName: sourceGeoContinentName,
  sourceGeoCountryName: sourceGeoCountryName,
  sourceGeoCountryIsoCode: sourceGeoCountryIsoCode,
  sourceGeoRegionName: sourceGeoRegionName,
  sourceGeoCityName: sourceGeoCityName,
  sourceIp: sourceIp,
  sourcePort: sourcePort,
  type: "destination"
}))));
exports.SourceDestinationWithArrows = SourceDestinationWithArrows;
SourceDestinationWithArrows.displayName = 'SourceDestinationWithArrows';