"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGeoFieldPropNameToFieldNameMap = exports.SOURCE_GEO_REGION_NAME_FIELD_NAME = exports.SOURCE_GEO_COUNTRY_NAME_FIELD_NAME = exports.SOURCE_GEO_COUNTRY_ISO_CODE_FIELD_NAME = exports.SOURCE_GEO_CONTINENT_NAME_FIELD_NAME = exports.SOURCE_GEO_CITY_NAME_FIELD_NAME = exports.GeoFields = exports.DESTINATION_GEO_REGION_NAME_FIELD_NAME = exports.DESTINATION_GEO_COUNTRY_NAME_FIELD_NAME = exports.DESTINATION_GEO_COUNTRY_ISO_CODE_FIELD_NAME = exports.DESTINATION_GEO_CONTINENT_NAME_FIELD_NAME = exports.DESTINATION_GEO_CITY_NAME_FIELD_NAME = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _draggables = require("../../../../common/components/draggables");
var _country_flag = require("./country_flag");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SOURCE_GEO_CONTINENT_NAME_FIELD_NAME = 'source.geo.continent_name';
exports.SOURCE_GEO_CONTINENT_NAME_FIELD_NAME = SOURCE_GEO_CONTINENT_NAME_FIELD_NAME;
const SOURCE_GEO_COUNTRY_NAME_FIELD_NAME = 'source.geo.country_name';
exports.SOURCE_GEO_COUNTRY_NAME_FIELD_NAME = SOURCE_GEO_COUNTRY_NAME_FIELD_NAME;
const SOURCE_GEO_COUNTRY_ISO_CODE_FIELD_NAME = 'source.geo.country_iso_code';
exports.SOURCE_GEO_COUNTRY_ISO_CODE_FIELD_NAME = SOURCE_GEO_COUNTRY_ISO_CODE_FIELD_NAME;
const SOURCE_GEO_REGION_NAME_FIELD_NAME = 'source.geo.region_name';
exports.SOURCE_GEO_REGION_NAME_FIELD_NAME = SOURCE_GEO_REGION_NAME_FIELD_NAME;
const SOURCE_GEO_CITY_NAME_FIELD_NAME = 'source.geo.city_name';
exports.SOURCE_GEO_CITY_NAME_FIELD_NAME = SOURCE_GEO_CITY_NAME_FIELD_NAME;
const DESTINATION_GEO_CONTINENT_NAME_FIELD_NAME = 'destination.geo.continent_name';
exports.DESTINATION_GEO_CONTINENT_NAME_FIELD_NAME = DESTINATION_GEO_CONTINENT_NAME_FIELD_NAME;
const DESTINATION_GEO_COUNTRY_NAME_FIELD_NAME = 'destination.geo.country_name';
exports.DESTINATION_GEO_COUNTRY_NAME_FIELD_NAME = DESTINATION_GEO_COUNTRY_NAME_FIELD_NAME;
const DESTINATION_GEO_COUNTRY_ISO_CODE_FIELD_NAME = 'destination.geo.country_iso_code';
exports.DESTINATION_GEO_COUNTRY_ISO_CODE_FIELD_NAME = DESTINATION_GEO_COUNTRY_ISO_CODE_FIELD_NAME;
const DESTINATION_GEO_REGION_NAME_FIELD_NAME = 'destination.geo.region_name';
exports.DESTINATION_GEO_REGION_NAME_FIELD_NAME = DESTINATION_GEO_REGION_NAME_FIELD_NAME;
const DESTINATION_GEO_CITY_NAME_FIELD_NAME = 'destination.geo.city_name';
exports.DESTINATION_GEO_CITY_NAME_FIELD_NAME = DESTINATION_GEO_CITY_NAME_FIELD_NAME;
const geoPropNameToFieldNameSuffix = [{
  prop: 'GeoContinentName',
  fieldName: 'geo.continent_name'
}, {
  prop: 'GeoCountryName',
  fieldName: 'geo.country_name'
}, {
  prop: 'GeoCountryIsoCode',
  fieldName: 'geo.country_iso_code'
}, {
  prop: 'GeoRegionName',
  fieldName: 'geo.region_name'
}, {
  prop: 'GeoCityName',
  fieldName: 'geo.city_name'
}];
const getGeoFieldPropNameToFieldNameMap = type => geoPropNameToFieldNameSuffix.map(({
  prop,
  fieldName
}) => ({
  prop: `${type}${prop}`,
  fieldName: `${type}.${fieldName}`
}));
exports.getGeoFieldPropNameToFieldNameMap = getGeoFieldPropNameToFieldNameMap;
const GeoFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin-right: 5px;
`;
GeoFlexItem.displayName = 'GeoFlexItem';
const GeoFieldValues = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  fieldName,
  isDraggable,
  values
}) => values != null ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _fp.uniq)(values).map(value => /*#__PURE__*/_react.default.createElement(GeoFlexItem, {
  grow: false,
  key: `${contextId}-${eventId}-${fieldName}-${value}`
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "none"
}, fieldName === SOURCE_GEO_COUNTRY_ISO_CODE_FIELD_NAME || fieldName === DESTINATION_GEO_COUNTRY_ISO_CODE_FIELD_NAME ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_country_flag.CountryFlag, {
  countryCode: value
})) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
  "data-test-subj": fieldName,
  field: fieldName,
  id: `geo-field-values-default-draggable-${contextId}-${eventId}-${fieldName}-${value}`,
  isDraggable: isDraggable,
  tooltipContent: fieldName,
  value: value
})))))) : null);
GeoFieldValues.displayName = 'GeoFieldValues';

/**
 * Renders a row of draggable text containing geographic fields, such as:
 * - `source|destination.geo.continent_name`
 * - `source|destination.geo.country_name`
 * - `source|destination.geo.country_iso_code`
 * - `source|destination.geo.region_iso_code`
 * - `source|destination.geo.city_name`
 */
const GeoFields = /*#__PURE__*/_react.default.memo(props => {
  const {
    contextId,
    eventId,
    isDraggable,
    type
  } = props;
  const propNameToFieldName = getGeoFieldPropNameToFieldNameMap(type);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none"
  }, (0, _fp.uniq)(propNameToFieldName).map(geo => /*#__PURE__*/_react.default.createElement(GeoFieldValues, {
    contextId: contextId,
    eventId: eventId,
    fieldName: geo.fieldName,
    isDraggable: isDraggable,
    key: geo.fieldName,
    values: (0, _fp.get)(geo.prop, props)
  })));
});
exports.GeoFields = GeoFields;
GeoFields.displayName = 'GeoFields';