"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDirectionIcon = exports.UNKNOWN = exports.OUTGOING = exports.OUTBOUND = exports.LISTENING = exports.INTERNAL = exports.INCOMING = exports.INBOUND = exports.EXTERNAL = exports.DirectionBadge = exports.DEFAULT_ICON = void 0;
var _react = _interopRequireDefault(require("react"));
var _search_strategy = require("../../../../../common/search_strategy");
var _draggables = require("../../../../common/components/draggables");
var _field_names = require("../source_destination/field_names");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INBOUND = 'inbound';
exports.INBOUND = INBOUND;
const OUTBOUND = 'outbound';
exports.OUTBOUND = OUTBOUND;
const EXTERNAL = 'external';
exports.EXTERNAL = EXTERNAL;
const INTERNAL = 'internal';
exports.INTERNAL = INTERNAL;
const INCOMING = 'incoming';
exports.INCOMING = INCOMING;
const OUTGOING = 'outgoing';
exports.OUTGOING = OUTGOING;
const LISTENING = 'listening';
exports.LISTENING = LISTENING;
const UNKNOWN = 'unknown';
exports.UNKNOWN = UNKNOWN;
const DEFAULT_ICON = 'questionInCircle';

/** Returns an icon representing the value of `network.direction` */
exports.DEFAULT_ICON = DEFAULT_ICON;
const getDirectionIcon = networkDirection => {
  if (networkDirection == null) {
    return DEFAULT_ICON;
  }
  const direction = `${networkDirection}`.toLowerCase();
  switch (direction) {
    case _search_strategy.NetworkDirectionEcs.outbound:
    case _search_strategy.NetworkDirectionEcs.outgoing:
      return 'arrowUp';
    case _search_strategy.NetworkDirectionEcs.inbound:
    case _search_strategy.NetworkDirectionEcs.incoming:
    case _search_strategy.NetworkDirectionEcs.listening:
      return 'arrowDown';
    case _search_strategy.NetworkDirectionEcs.external:
      return 'globe';
    case _search_strategy.NetworkDirectionEcs.internal:
      return 'bullseye';
    case _search_strategy.NetworkDirectionEcs.unknown:
    default:
      return DEFAULT_ICON;
  }
};

/**
 * Renders a badge containing the value of `network.direction`
 */
exports.getDirectionIcon = getDirectionIcon;
const DirectionBadge = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  direction,
  isDraggable
}) => /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  contextId: contextId,
  eventId: eventId,
  field: _field_names.NETWORK_DIRECTION_FIELD_NAME,
  iconType: getDirectionIcon(direction),
  isDraggable: isDraggable,
  value: direction,
  isAggregatable: true,
  fieldType: "keyword"
}));
exports.DirectionBadge = DirectionBadge;
DirectionBadge.displayName = 'DirectionBadge';