"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExploreLandingPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _types = require("../app/types");
var _header_page = require("../common/components/header_page");
var _nav_links = require("../common/links/nav_links");
var _page_wrapper = require("../common/components/page_wrapper");
var _spy_routes = require("../common/utils/route/spy_routes");
var _landing_links_images = require("../common/components/landing_links/landing_links_images");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EXPLORE_PAGE_TITLE = _i18n.i18n.translate('xpack.securitySolution.explore.landing.pageTitle', {
  defaultMessage: 'Explore'
});
const ExploreLandingPage = () => {
  var _useRootNavLink$links, _useRootNavLink;
  const exploreLinks = (_useRootNavLink$links = (_useRootNavLink = (0, _nav_links.useRootNavLink)(_types.SecurityPageName.exploreLanding)) === null || _useRootNavLink === void 0 ? void 0 : _useRootNavLink.links) !== null && _useRootNavLink$links !== void 0 ? _useRootNavLink$links : [];
  return /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, null, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: EXPLORE_PAGE_TITLE
  }), /*#__PURE__*/_react.default.createElement(_landing_links_images.LandingLinksImages, {
    items: exploreLinks
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.exploreLanding
  }));
};
exports.ExploreLandingPage = ExploreLandingPage;