"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UncommonProcessQueryTabBody = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _uncommon_processes = require("../../containers/uncommon_processes");
var _uncommon_process_table = require("../../components/uncommon_process_table");
var _manage_query = require("../../../../common/components/page/manage_query");
var _query_toggle = require("../../../../common/containers/query_toggle");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UncommonProcessTableManage = (0, _manage_query.manageQuery)(_uncommon_process_table.UncommonProcessTable);
const UncommonProcessQueryTabBody = ({
  deleteQuery,
  endDate,
  filterQuery,
  indexNames,
  skip,
  setQuery,
  startDate,
  type
}) => {
  const {
    toggleStatus
  } = (0, _query_toggle.useQueryToggle)(_uncommon_processes.ID);
  const [querySkip, setQuerySkip] = (0, _react.useState)(skip || !toggleStatus);
  (0, _react.useEffect)(() => {
    setQuerySkip(skip || !toggleStatus);
  }, [skip, toggleStatus]);
  const [loading, {
    uncommonProcesses,
    totalCount,
    pageInfo,
    loadPage,
    id,
    inspect,
    isInspected,
    refetch
  }] = (0, _uncommon_processes.useUncommonProcesses)({
    endDate,
    filterQuery,
    indexNames,
    skip: querySkip,
    startDate,
    type
  });
  return /*#__PURE__*/_react.default.createElement(UncommonProcessTableManage, {
    deleteQuery: deleteQuery,
    data: uncommonProcesses,
    fakeTotalCount: (0, _fp.getOr)(50, 'fakeTotalCount', pageInfo),
    id: id,
    inspect: inspect,
    isInspect: isInspected,
    loading: loading,
    loadPage: loadPage,
    refetch: refetch,
    setQuery: setQuery,
    setQuerySkip: setQuerySkip,
    showMorePagesIndicator: (0, _fp.getOr)(false, 'showMorePagesIndicator', pageInfo),
    totalCount: totalCount,
    type: type
  });
};
exports.UncommonProcessQueryTabBody = UncommonProcessQueryTabBody;
UncommonProcessQueryTabBody.dispalyName = 'UncommonProcessQueryTabBody';