"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostRiskScoreQueryTabBody = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _enable_risk_score = require("../../../components/risk_score/enable_risk_score");
var _manage_query = require("../../../../common/components/page/manage_query");
var _host_risk_score_table = require("../../components/host_risk_score_table");
var _use_selector = require("../../../../common/hooks/use_selector");
var _store = require("../../store");
var _risk_score = require("../../../containers/risk_score");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _search_strategy = require("../../../../../common/search_strategy");
var _risk_score_no_data_detected = require("../../../components/risk_score/risk_score_onboarding/risk_score_no_data_detected");
var _use_upselling = require("../../../../common/hooks/use_upselling");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HostRiskScoreTableManage = (0, _manage_query.manageQuery)(_host_risk_score_table.HostRiskScoreTable);
const HostRiskScoreQueryTabBody = ({
  deleteQuery,
  endDate: to,
  filterQuery,
  setQuery,
  skip,
  startDate: from,
  type
}) => {
  const RiskScoreUpsell = (0, _use_upselling.useUpsellingComponent)('entity_analytics_panel');
  const getHostRiskScoreSelector = (0, _react.useMemo)(() => _store.hostsSelectors.hostRiskScoreSelector(), []);
  const {
    activePage,
    limit,
    sort
  } = (0, _use_selector.useDeepEqualSelector)(state => getHostRiskScoreSelector(state, _store.hostsModel.HostsType.page));
  const getHostRiskScoreFilterQuerySelector = (0, _react.useMemo)(() => _store.hostsSelectors.hostRiskScoreSeverityFilterSelector(), []);
  const severitySelectionRedux = (0, _use_selector.useDeepEqualSelector)(state => getHostRiskScoreFilterQuerySelector(state, _store.hostsModel.HostsType.page));
  const pagination = (0, _react.useMemo)(() => ({
    cursorStart: activePage * limit,
    querySize: limit
  }), [activePage, limit]);
  const {
    toggleStatus
  } = (0, _query_toggle.useQueryToggle)(_risk_score.HostRiskScoreQueryId.HOSTS_BY_RISK);
  const [querySkip, setQuerySkip] = (0, _react.useState)(skip || !toggleStatus);
  (0, _react.useEffect)(() => {
    setQuerySkip(!toggleStatus);
  }, [toggleStatus]);
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const {
    data,
    inspect,
    isDeprecated,
    isInspected,
    isModuleEnabled,
    loading,
    refetch,
    totalCount
  } = (0, _risk_score.useRiskScore)({
    filterQuery,
    pagination,
    riskEntity: _search_strategy.RiskScoreEntity.host,
    skip: querySkip,
    sort,
    timerange
  });
  const {
    severityCount,
    loading: isKpiLoading
  } = (0, _risk_score.useRiskScoreKpi)({
    filterQuery,
    skip: querySkip,
    riskEntity: _search_strategy.RiskScoreEntity.host
  });
  const status = {
    isDisabled: !isModuleEnabled && !loading,
    isDeprecated: isDeprecated && !loading
  };
  if (RiskScoreUpsell) {
    return /*#__PURE__*/_react.default.createElement(RiskScoreUpsell, null);
  }
  if (status.isDisabled || status.isDeprecated) {
    return /*#__PURE__*/_react.default.createElement(_enable_risk_score.EnableRiskScore, (0, _extends2.default)({}, status, {
      entityType: _search_strategy.RiskScoreEntity.host,
      refetch: refetch,
      timerange: timerange
    }));
  }
  if (!loading && isModuleEnabled && severitySelectionRedux.length === 0 && data && data.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_risk_score_no_data_detected.RiskScoresNoDataDetected, {
      entityType: _search_strategy.RiskScoreEntity.host,
      refetch: refetch
    });
  }
  return /*#__PURE__*/_react.default.createElement(HostRiskScoreTableManage, {
    deleteQuery: deleteQuery,
    data: data !== null && data !== void 0 ? data : [],
    id: _risk_score.HostRiskScoreQueryId.HOSTS_BY_RISK,
    inspect: inspect,
    isInspect: isInspected,
    loading: loading || isKpiLoading,
    loadPage: _fp.noop // It isn't necessary because PaginatedTable updates redux store and we load the page when activePage updates on the store
    ,
    refetch: refetch,
    setQuery: setQuery,
    setQuerySkip: setQuerySkip,
    severityCount: severityCount !== null && severityCount !== void 0 ? severityCount : _search_strategy.EMPTY_SEVERITY_COUNT,
    totalCount: totalCount,
    type: type
  });
};
exports.HostRiskScoreQueryTabBody = HostRiskScoreQueryTabBody;
HostRiskScoreQueryTabBody.displayName = 'HostRiskScoreQueryTabBody';