"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostsKpiComponent = exports.HostsDetailsKpiComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _hosts = require("./hosts");
var _unique_ips = require("./unique_ips");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HostsKpiComponent = /*#__PURE__*/_react.default.memo(({
  filterQuery,
  from,
  indexNames,
  to,
  setQuery,
  skip,
  updateDateRange
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  wrap: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 1
}, /*#__PURE__*/_react.default.createElement(_hosts.HostsKpiHosts, {
  filterQuery: filterQuery,
  from: from,
  indexNames: indexNames,
  to: to,
  updateDateRange: updateDateRange,
  setQuery: setQuery,
  skip: skip
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 2
}, /*#__PURE__*/_react.default.createElement(_unique_ips.HostsKpiUniqueIps, {
  filterQuery: filterQuery,
  from: from,
  indexNames: indexNames,
  to: to,
  updateDateRange: updateDateRange,
  setQuery: setQuery,
  skip: skip
}))));
exports.HostsKpiComponent = HostsKpiComponent;
HostsKpiComponent.displayName = 'HostsKpiComponent';
const HostsDetailsKpiComponent = /*#__PURE__*/_react.default.memo(({
  filterQuery,
  from,
  indexNames,
  to,
  setQuery,
  skip,
  updateDateRange
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_unique_ips.HostsKpiUniqueIps, {
    filterQuery: filterQuery,
    from: from,
    indexNames: indexNames,
    to: to,
    updateDateRange: updateDateRange,
    setQuery: setQuery,
    skip: skip
  })));
});
exports.HostsDetailsKpiComponent = HostsDetailsKpiComponent;
HostsDetailsKpiComponent.displayName = 'HostsDetailsKpiComponent';