"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeverityBadges = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SeverityBadges = /*#__PURE__*/_react.default.memo(({
  severityCount
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "spaceBetween",
  gutterSize: "m",
  "data-test-subj": "risk-score-severity-badges"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "m"
}, Object.keys(_common.RISK_SEVERITY_COLOUR).map(status => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  key: status,
  grow: false
}, /*#__PURE__*/_react.default.createElement(SeverityBadge, {
  status: status,
  count: severityCount[status] || 0
})))))));
exports.SeverityBadges = SeverityBadges;
SeverityBadges.displayName = 'SeverityBadges';
const SeverityBadge = /*#__PURE__*/_react.default.memo(({
  status,
  count
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_common.RiskScore, {
  severity: status
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
  size: "s",
  color: "subdued"
}, count))));
SeverityBadge.displayName = 'SeverityBadge';