"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreEnableButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_space_id = require("../../../../common/hooks/use_space_id");
var _kibana = require("../../../../common/lib/kibana");
var _use_fetch = require("../../../../common/hooks/use_fetch");
var _use_risk_score_toast_content = require("./use_risk_score_toast_content");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskScoreEnableButtonComponent = ({
  refetch,
  riskScoreEntity,
  disabled = false,
  timerange
}) => {
  const spaceId = (0, _use_space_id.useSpaceId)();
  const {
    http,
    notifications,
    theme,
    dashboard
  } = (0, _kibana.useKibana)().services;
  const {
    renderDocLink,
    renderDashboardLink
  } = (0, _use_risk_score_toast_content.useRiskScoreToastContent)(riskScoreEntity);
  const {
    fetch,
    isLoading
  } = (0, _use_fetch.useFetch)(_use_fetch.REQUEST_NAMES.ENABLE_RISK_SCORE, _utils.installRiskScoreModule);
  const onBoardingRiskScore = (0, _react.useCallback)(() => {
    fetch({
      dashboard,
      http,
      notifications,
      refetch,
      renderDashboardLink,
      renderDocLink,
      riskScoreEntity,
      spaceId,
      theme,
      timerange
    });
  }, [dashboard, fetch, http, notifications, refetch, renderDashboardLink, renderDocLink, riskScoreEntity, spaceId, theme, timerange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    onClick: onBoardingRiskScore,
    isLoading: isLoading,
    "data-test-subj": `enable_${riskScoreEntity}_risk_score`,
    disabled: disabled
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskScore.enableButtonTitle",
    defaultMessage: "Enable"
  }));
};
const RiskScoreEnableButton = /*#__PURE__*/_react.default.memo(RiskScoreEnableButtonComponent);
exports.RiskScoreEnableButton = RiskScoreEnableButton;
RiskScoreEnableButton.displayName = 'RiskScoreEnableButton';