"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnableRiskScore = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _risk_score_upgrade_button = require("../risk_score_onboarding/risk_score_upgrade_button");
var _use_check_signal_index = require("../../../../detections/containers/detection_engine/alerts/use_check_signal_index");
var _risk_score_header_title = require("../risk_score_onboarding/risk_score_header_title");
var _header_section = require("../../../../common/components/header_section");
var _risk_score_doc_link = require("../risk_score_onboarding/risk_score_doc_link");
var _risk_score_enable_button = require("../risk_score_onboarding/risk_score_enable_button");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnableRiskScoreComponent = ({
  isDeprecated,
  isDisabled,
  entityType,
  refetch,
  timerange
}) => {
  const {
    signalIndexExists
  } = (0, _use_check_signal_index.useCheckSignalIndex)();
  if (!isDeprecated && !isDisabled) {
    return null;
  }
  const text = isDeprecated ? {
    cta: i18n.UPGRADE_RISK_SCORE(entityType),
    body: i18n.UPGRADE_RISK_SCORE_DESCRIPTION
  } : {
    cta: i18n.ENABLE_RISK_SCORE(entityType),
    body: i18n.ENABLE_RISK_SCORE_DESCRIPTION(entityType)
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: /*#__PURE__*/_react.default.createElement(_risk_score_header_title.RiskScoreHeaderTitle, {
      riskScoreEntity: entityType,
      showTechnicalPreviewBadge: true
    }),
    titleSize: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", null, text.cta),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, text.body, ` `, /*#__PURE__*/_react.default.createElement(_risk_score_doc_link.RiskScoreDocLink, {
      riskScoreEntity: entityType
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: !signalIndexExists ? i18n.ENABLE_RISK_SCORE_POPOVER : null
    }, isDeprecated ? /*#__PURE__*/_react.default.createElement(_risk_score_upgrade_button.RiskScoreUpgradeButton, {
      refetch: refetch,
      riskScoreEntity: entityType,
      disabled: !signalIndexExists,
      timerange: timerange,
      "data-test-subj": `upgrade_${entityType}_risk_score`,
      title: text.cta
    }) : /*#__PURE__*/_react.default.createElement(_risk_score_enable_button.RiskScoreEnableButton, {
      disabled: !signalIndexExists,
      refetch: refetch,
      riskScoreEntity: entityType,
      timerange: timerange
    }))
  }));
};
const EnableRiskScore = /*#__PURE__*/_react.default.memo(EnableRiskScoreComponent);
exports.EnableRiskScore = EnableRiskScore;
EnableRiskScore.displayName = 'EnableRiskScore';