"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsUtility = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _formatted_date = require("../../../common/components/formatted_date");
var _utility_bar = require("../../../common/components/utility_bar");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledText = _styledComponents.default.span`
  font-weight: bold;
  color: ${({
  theme
}) => theme.eui.euiColorDarkestShade};
`;
const MyUtilities = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  height: 50px;
`;
const StyledCondition = _styledComponents.default.span`
  display: inline-block !important;
  vertical-align: middle !important;
  line-height: 1;
`;
// This component should be removed and moved to @kbn/securitysolution-exception-list-components
// once all the building components get moved

const ExceptionsUtilityComponent = ({
  dataTestSubj,
  pagination,
  lastUpdated,
  exceptionsTitle
}) => {
  const {
    pageSize,
    totalItemCount
  } = pagination;
  return /*#__PURE__*/_react.default.createElement(MyUtilities, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBar, null, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarSection, null, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, null, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarText, {
    dataTestSubj: `${dataTestSubj}ShowingText`
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.exceptions.viewer.paginationDetails",
    defaultMessage: "Showing {partOne} of {partTwo}",
    values: {
      partOne: /*#__PURE__*/_react.default.createElement(StyledText, null, `1-${Math.min(pageSize, totalItemCount)}`),
      partTwo: /*#__PURE__*/_react.default.createElement(StyledText, null, `${totalItemCount}`)
    }
  })), exceptionsTitle && /*#__PURE__*/_react.default.createElement(StyledText, {
    "data-test-subj": `${dataTestSubj}exceptionsTitle`
  }, exceptionsTitle))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": `${dataTestSubj}LastUpdated`
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.exceptions.viewer.lastUpdated",
    defaultMessage: "Updated {updated}",
    values: {
      updated: /*#__PURE__*/_react.default.createElement(StyledCondition, null, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
        value: lastUpdated,
        tooltipAnchorClassName: "eui-textTruncate"
      }))
    }
  }))));
};
ExceptionsUtilityComponent.displayName = 'ExceptionsUtilityComponent';
const ExceptionsUtility = /*#__PURE__*/_react.default.memo(ExceptionsUtilityComponent);
exports.ExceptionsUtility = ExceptionsUtility;
ExceptionsUtility.displayName = 'ExceptionsUtility';