"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateSharedListFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../common/constants");
var _use_create_shared_list = require("../../hooks/use_create_shared_list");
var _translations = require("../../translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateSharedListFlyout = /*#__PURE__*/(0, _react.memo)(({
  handleRefresh,
  http,
  handleCloseFlyout,
  addSuccess,
  addError
}) => {
  const {
    navigateToApp
  } = (0, _public.useKibana)().services.application;
  const {
    start: createSharedExceptionList,
    ...createSharedExceptionListState
  } = (0, _use_create_shared_list.useCreateSharedExceptionListWithOptionalSignal)();
  const ctrl = (0, _react.useRef)(new AbortController());
  let DetailProperty;
  (function (DetailProperty) {
    DetailProperty["name"] = "name";
    DetailProperty["description"] = "description";
  })(DetailProperty || (DetailProperty = {}));
  const [newListDetails, setNewListDetails] = (0, _react.useState)({
    name: '',
    description: ''
  });
  const onChange = ({
    target
  }, detailProperty) => {
    const {
      value
    } = target;
    setNewListDetails({
      ...newListDetails,
      [detailProperty]: value
    });
  };
  (0, _react.useEffect)(() => {
    if (createSharedExceptionListState.result != null) {
      navigateToApp(_constants.APP_UI_ID, {
        deepLinkId: _constants.SecurityPageName.exceptions,
        path: `/details/${createSharedExceptionListState.result.list_id}`
      });
    }
  }, [createSharedExceptionListState, navigateToApp]);
  const handleCreateSharedExceptionList = (0, _react.useCallback)(() => {
    if (!createSharedExceptionListState.loading && newListDetails.name !== '') {
      var _newListDetails$descr;
      ctrl.current = new AbortController();
      createSharedExceptionList({
        http,
        signal: ctrl.current.signal,
        name: newListDetails.name,
        description: (_newListDetails$descr = newListDetails.description) !== null && _newListDetails$descr !== void 0 ? _newListDetails$descr : ''
      });
    }
  }, [createSharedExceptionListState.loading, newListDetails.name, newListDetails.description, createSharedExceptionList, http]);
  const handleCreateSuccess = (0, _react.useCallback)(response => {
    addSuccess({
      text: (0, _translations.getSuccessText)(newListDetails.name),
      title: _translations.SUCCESS_TITLE
    });
    handleRefresh();
    handleCloseFlyout();
  }, [addSuccess, handleCloseFlyout, handleRefresh, newListDetails]);
  const handleCreateError = (0, _react.useCallback)(error => {
    var _error$body;
    if (!error.message.includes('AbortError') && !(error !== null && error !== void 0 && (_error$body = error.body) !== null && _error$body !== void 0 && _error$body.message.includes('AbortError'))) {
      addError(error, {
        title: _i18n.i18n.translate('xpack.securitySolution.exceptions.createSharedExceptionListErrorTitle', {
          defaultMessage: 'creation error'
        })
      });
    }
  }, [addError]);
  (0, _react.useEffect)(() => {
    if (!createSharedExceptionListState.loading) {
      if (createSharedExceptionListState !== null && createSharedExceptionListState !== void 0 && createSharedExceptionListState.result) {
        handleCreateSuccess(createSharedExceptionListState.result);
      } else if (createSharedExceptionListState !== null && createSharedExceptionListState !== void 0 && createSharedExceptionListState.error) {
        handleCreateError(createSharedExceptionListState === null || createSharedExceptionListState === void 0 ? void 0 : createSharedExceptionListState.error);
      }
    }
  }, [createSharedExceptionListState === null || createSharedExceptionListState === void 0 ? void 0 : createSharedExceptionListState.error, createSharedExceptionListState.loading, createSharedExceptionListState.result, handleCreateError, handleCreateSuccess]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    size: "s",
    onClose: handleCloseFlyout,
    "data-test-subj": "createSharedExceptionListFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "createSharedExceptionListTitle"
  }, _translations.CREATE_SHARED_LIST_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _translations.CREATE_SHARED_LIST_NAME_FIELD), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _translations.CREATE_SHARED_LIST_NAME_FIELD_PLACEHOLDER,
    value: newListDetails.name,
    onChange: e => onChange(e, DetailProperty.name),
    "aria-label": "Shared exception list name",
    "data-test-subj": "createSharedExceptionListNameInput"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _translations.CREATE_SHARED_LIST_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    placeholder: _translations.CREATE_SHARED_LIST_DESCRIPTION_PLACEHOLDER,
    value: newListDetails.description,
    onChange: e => onChange(e, DetailProperty.description),
    "aria-label": "Shared exception list description",
    "data-test-subj": "createSharedExceptionListDescriptionInput"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: handleCloseFlyout,
    flush: "left"
  }, _translations.CLOSE_FLYOUT)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "exception-lists-form-create-shared",
    onClick: handleCreateSharedExceptionList,
    disabled: newListDetails.name === ''
  }, _translations.CREATE_BUTTON)))));
});
exports.CreateSharedListFlyout = CreateSharedListFlyout;
CreateSharedListFlyout.displayName = 'CreateSharedListFlyout';