"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummaryRow = exports.SummaryPanel = exports.SummaryColumn = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _hover_visibility_container = require("../../../../../common/components/hover_visibility_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SummaryColumn = ({
  children,
  grow
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: grow
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  wrap: false,
  css: (0, _react2.css)`
        flex-wrap: nowrap;
      `
}, children));
exports.SummaryColumn = SummaryColumn;
const SummaryRow = ({
  children,
  grow
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: grow
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "row",
  wrap: true
}, children));
exports.SummaryRow = SummaryRow;
const SummaryPanel = ({
  actionsClassName,
  children,
  description,
  grow = false,
  renderActionsPopover,
  title
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: grow
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  hasShadow: false,
  hasBorder: true
}, /*#__PURE__*/_react.default.createElement(_hover_visibility_container.HoverVisibilityContainer, {
  targetClassNames: [actionsClassName !== null && actionsClassName !== void 0 ? actionsClassName : '']
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "row",
  justifyContent: "spaceBetween"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h3", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs"
}), description && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "subdued",
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("p", null, description))), actionsClassName && renderActionsPopover ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, renderActionsPopover()) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
}), children));
exports.SummaryPanel = SummaryPanel;